/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.location.zzm;

public final class LocationRequest
extends zza
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    int mPriority;
    long zzbjT;
    long zzbjU;
    boolean zzaWy;
    long zzbjD;
    int zzbjV;
    float zzbjW;
    long zzbjX;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzm();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mPriority = 102;
        this.zzbjT = 3600000L;
        this.zzbjU = 600000L;
        this.zzaWy = false;
        this.zzbjD = Long.MAX_VALUE;
        this.zzbjV = Integer.MAX_VALUE;
        this.zzbjW = 0.0f;
        this.zzbjX = 0L;
    }

    public LocationRequest setPriority(int n) {
        LocationRequest.zzkk(n);
        this.mPriority = n;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long l) {
        LocationRequest.zzV(l);
        this.zzbjT = l;
        if (!this.zzaWy) {
            this.zzbjU = (long)((double)this.zzbjT / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzbjT;
    }

    public LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzV(l);
        this.zzbjX = l;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzbjX;
        if (l < this.zzbjT) {
            l = this.zzbjT;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long l) {
        LocationRequest.zzV(l);
        this.zzaWy = true;
        this.zzbjU = l;
        return this;
    }

    public long getFastestInterval() {
        return this.zzbjU;
    }

    public LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzbjD = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzbjD < 0L) {
            this.zzbjD = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long l) {
        this.zzbjD = l;
        if (this.zzbjD < 0L) {
            this.zzbjD = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzbjD;
    }

    public LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzbjV = n;
        return this;
    }

    public int getNumUpdates() {
        return this.zzbjV;
    }

    public LocationRequest setSmallestDisplacement(float f) {
        LocationRequest.zze(f);
        this.zzbjW = f;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzbjW;
    }

    private static void zzV(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    private static void zzkk(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
    }

    private static void zze(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
    }

    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzbjT = l;
        this.zzbjU = l2;
        this.zzaWy = bl;
        this.zzbjD = l3;
        this.zzbjV = n2;
        this.zzbjW = f;
        this.zzbjX = l4;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzm.zza(this, parcel, n);
    }

    public static String zzkl(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzkl(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzbjT).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzbjU).append("ms");
        if (this.zzbjX > this.zzbjT) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzbjX).append("ms");
        }
        if (this.zzbjW > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzbjW).append("m");
        }
        if (this.zzbjD != Long.MAX_VALUE) {
            long l = this.zzbjD - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzbjV != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzbjV);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.mPriority, this.zzbjT, Float.valueOf(this.zzbjW), this.zzbjX});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzbjT == locationRequest.zzbjT && this.zzbjU == locationRequest.zzbjU && this.zzaWy == locationRequest.zzaWy && this.zzbjD == locationRequest.zzbjD && this.zzbjV == locationRequest.zzbjV && this.zzbjW == locationRequest.zzbjW && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

