/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbk;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzbce;
import com.google.android.gms.internal.zzbfi;
import com.google.android.gms.internal.zzbfk;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfq;
import com.google.android.gms.internal.zzbfy;
import com.google.android.gms.internal.zzbgd;
import com.google.android.gms.internal.zzbgk;
import com.google.android.gms.internal.zzcea;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfn;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.zze;
import com.google.android.gms.location.zzf;
import com.google.android.gms.location.zzg;
import com.google.android.gms.location.zzh;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class FusedLocationProviderClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    public FusedLocationProviderClient(@NonNull Context context) {
        super(context, LocationServices.API, null, (zzbfy)new zzbce());
    }

    public FusedLocationProviderClient(@NonNull Activity activity) {
        super(activity, LocationServices.API, null, (zzbfy)new zzbce());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Location> getLastLocation() {
        return this.zza(new zze(this));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<LocationAvailability> getLocationAvailability() {
        return this.zza(new zzf(this));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationCallback locationCallback, @Nullable Looper looper) {
        zzh zzh2;
        zzcez zzcez2 = zzcez.zza(locationRequest);
        Looper looper2 = looper;
        LocationCallback locationCallback2 = locationCallback;
        zzcez zzcez3 = zzcez2;
        FusedLocationProviderClient fusedLocationProviderClient = this;
        zzbfi zzbfi2 = zzbfm.zzb((Object)locationCallback2, (Looper)zzcfn.zzb(looper2), (String)LocationCallback.class.getSimpleName());
        zzg zzg2 = new zzg(fusedLocationProviderClient, zzbfi2, zzcez3, zzbfi2);
        zzh zzh3 = zzh2 = new zzh(fusedLocationProviderClient, zzbfi2.zzqE());
        zzg zzg3 = zzg2;
        FusedLocationProviderClient fusedLocationProviderClient2 = fusedLocationProviderClient;
        zzbr.zzu((Object)((Object)zzg3));
        zzbr.zzu((Object)((Object)zzh3));
        zzbr.zzb((Object)zzg3.zzqE(), (Object)"Listener has already been released.");
        zzbr.zzb((Object)zzh3.zzqE(), (Object)"Listener has already been released.");
        zzbr.zzb((boolean)zzg3.zzqE().equals((Object)zzh3.zzqE()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return fusedLocationProviderClient2.zzaAP.zza((GoogleApi)fusedLocationProviderClient2, (zzbfq)zzg3, (zzbgk)zzh3);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        return zzbk.zzb(LocationServices.FusedLocationApi.requestLocationUpdates(this.zzpg(), locationRequest, pendingIntent));
    }

    public Task<Void> removeLocationUpdates(PendingIntent pendingIntent) {
        return zzbk.zzb(LocationServices.FusedLocationApi.removeLocationUpdates(this.zzpg(), pendingIntent));
    }

    public Task<Void> removeLocationUpdates(LocationCallback locationCallback) {
        zzbfk zzbfk2 = zzbfm.zza((Object)locationCallback, (String)LocationCallback.class.getSimpleName());
        FusedLocationProviderClient fusedLocationProviderClient = this;
        zzbr.zzb((Object)zzbfk2, (Object)"Listener key cannot be null.");
        return fusedLocationProviderClient.zzaAP.zza((GoogleApi)fusedLocationProviderClient, zzbfk2);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockMode(boolean bl) {
        return zzbk.zzb(LocationServices.FusedLocationApi.setMockMode(this.zzpg(), bl));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockLocation(Location location) {
        return zzbk.zzb(LocationServices.FusedLocationApi.setMockLocation(this.zzpg(), location));
    }

    public Task<Void> flushLocations() {
        return zzbk.zzb(LocationServices.FusedLocationApi.flushLocations(this.zzpg()));
    }

    static final class zza
    extends zzceh {
        private final TaskCompletionSource<Void> zzalG;

        public zza(TaskCompletionSource<Void> taskCompletionSource) {
            this.zzalG = taskCompletionSource;
        }

        @Override
        public final void zza(zzcea zzcea2) {
            TaskCompletionSource<Void> taskCompletionSource = this.zzalG;
            zzbgd.zza((Status)zzcea2.getStatus(), null, taskCompletionSource);
        }
    }
}

