/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.zzcfd;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzQz = null;
        private int zzbhJ = 0;
        private long zzbhK = Long.MIN_VALUE;
        private short zzbhL = (short)-1;
        private double zzbhM;
        private double zzbhN;
        private float zzbhO;
        private int zzbhP = 0;
        private int zzbhQ = -1;

        public final Builder setRequestId(String string) {
            this.zzQz = string;
            return this;
        }

        public final Builder setTransitionTypes(int n) {
            this.zzbhJ = n;
            return this;
        }

        public final Builder setExpirationDuration(long l) {
            this.zzbhK = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public final Builder setCircularRegion(double d, double d2, float f) {
            this.zzbhL = 1;
            this.zzbhM = d;
            this.zzbhN = d2;
            this.zzbhO = f;
            return this;
        }

        public final Builder setNotificationResponsiveness(int n) {
            this.zzbhP = n;
            return this;
        }

        public final Builder setLoiteringDelay(int n) {
            this.zzbhQ = n;
            return this;
        }

        public final Geofence build() {
            if (this.zzQz == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzbhJ == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzbhJ & 4) != 0 && this.zzbhQ < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzbhK == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzbhL == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzbhP < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new zzcfd(this.zzQz, this.zzbhJ, 1, this.zzbhM, this.zzbhN, this.zzbhO, this.zzbhK, this.zzbhP, this.zzbhQ);
        }
    }
}

