/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzi;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends zza {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzi();
    private final List<zzcfd> zzbhU;
    private final int zzbhV;
    private final String mTag;

    GeofencingRequest(List<zzcfd> list, int n, String string) {
        this.zzbhU = list;
        this.zzbhV = n;
        this.mTag = string;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzbhU);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzbhV;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GeofencingRequest geofencingRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, geofencingRequest.zzbhU, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, (int)geofencingRequest.getInitialTrigger());
        zzd.zza((Parcel)parcel2, (int)3, (String)geofencingRequest.mTag, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private final List<zzcfd> zzbhU = new ArrayList<zzcfd>();
        private int zzbhV = 5;
        private String mTag = "";

        public final Builder addGeofence(Geofence geofence) {
            zzbr.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzbr.zzb((boolean)(geofence instanceof zzcfd), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzbhU.add((zzcfd)geofence);
            return this;
        }

        public final Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public final Builder setInitialTrigger(int n) {
            this.zzbhV = n & 7;
            return this;
        }

        public final GeofencingRequest build() {
            zzbr.zzb((!this.zzbhU.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzbhU, this.zzbhV, this.mTag);
        }
    }
}

