/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzbar;
import com.google.android.gms.internal.zzbdv;
import com.google.android.gms.internal.zzbdx;
import com.google.android.gms.internal.zzbdz;
import com.google.android.gms.internal.zzbed;
import com.google.android.gms.internal.zzbel;
import com.google.android.gms.internal.zzbeq;
import com.google.android.gms.internal.zzbex;
import com.google.android.gms.internal.zzccn;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdm;
import com.google.android.gms.internal.zzcea;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.zze;
import com.google.android.gms.location.zzf;
import com.google.android.gms.location.zzg;
import com.google.android.gms.location.zzh;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class FusedLocationProviderClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    public FusedLocationProviderClient(@NonNull Context context) {
        super(context, LocationServices.API, null, (zzbel)new zzbar());
    }

    public FusedLocationProviderClient(@NonNull Activity activity) {
        super(activity, LocationServices.API, null, (zzbel)new zzbar());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Location> getLastLocation() {
        return this.zza(new zze(this));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<LocationAvailability> getLocationAvailability() {
        return this.zza(new zzf(this));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationCallback locationCallback, @Nullable Looper looper) {
        zzh zzh2;
        zzcdm zzcdm2 = zzcdm.zza(locationRequest);
        Looper looper2 = looper;
        LocationCallback locationCallback2 = locationCallback;
        zzcdm zzcdm3 = zzcdm2;
        FusedLocationProviderClient fusedLocationProviderClient = this;
        zzbdv zzbdv2 = zzbdz.zzb((Object)locationCallback2, (Looper)zzcea.zzb(looper2), (String)LocationCallback.class.getSimpleName());
        zzg zzg2 = new zzg(fusedLocationProviderClient, zzbdv2, zzcdm3, zzbdv2);
        zzh zzh3 = zzh2 = new zzh(fusedLocationProviderClient, zzbdv2.zzqG());
        zzg zzg3 = zzg2;
        FusedLocationProviderClient fusedLocationProviderClient2 = fusedLocationProviderClient;
        zzbo.zzu((Object)((Object)zzg3));
        zzbo.zzu((Object)((Object)zzh3));
        zzbo.zzb((Object)zzg3.zzqG(), (Object)"Listener has already been released.");
        zzbo.zzb((Object)zzh3.zzqG(), (Object)"Listener has already been released.");
        zzbo.zzb((boolean)zzg3.zzqG().equals((Object)zzh3.zzqG()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return fusedLocationProviderClient2.zzaAN.zza((GoogleApi)fusedLocationProviderClient2, (zzbed)zzg3, (zzbex)zzh3);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        return zzbh.zzb(LocationServices.FusedLocationApi.requestLocationUpdates(this.zzpi(), locationRequest, pendingIntent));
    }

    public Task<Void> removeLocationUpdates(PendingIntent pendingIntent) {
        return zzbh.zzb(LocationServices.FusedLocationApi.removeLocationUpdates(this.zzpi(), pendingIntent));
    }

    public Task<Void> removeLocationUpdates(LocationCallback locationCallback) {
        zzbdx zzbdx2 = zzbdz.zza((Object)locationCallback, (String)LocationCallback.class.getSimpleName());
        FusedLocationProviderClient fusedLocationProviderClient = this;
        zzbo.zzb((Object)zzbdx2, (Object)"Listener key cannot be null.");
        return fusedLocationProviderClient.zzaAN.zza((GoogleApi)fusedLocationProviderClient, zzbdx2);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockMode(boolean bl) {
        return zzbh.zzb(LocationServices.FusedLocationApi.setMockMode(this.zzpi(), bl));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockLocation(Location location) {
        return zzbh.zzb(LocationServices.FusedLocationApi.setMockLocation(this.zzpi(), location));
    }

    public Task<Void> flushLocations() {
        return zzbh.zzb(LocationServices.FusedLocationApi.flushLocations(this.zzpi()));
    }

    static final class zza
    extends zzccu {
        private final TaskCompletionSource<Void> zzalE;

        public zza(TaskCompletionSource<Void> taskCompletionSource) {
            this.zzalE = taskCompletionSource;
        }

        @Override
        public final void zza(zzccn zzccn2) {
            TaskCompletionSource<Void> taskCompletionSource = this.zzalE;
            zzbeq.zza((Status)zzccn2.getStatus(), null, taskCompletionSource);
        }
    }
}

