/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.location.zzr;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LocationResult
extends zza
implements ReflectedParcelable {
    static final List<Location> zzbic = Collections.emptyList();
    private final List<Location> zzbid;
    public static final Parcelable.Creator<LocationResult> CREATOR = new zzr();

    public static LocationResult create(List<Location> list) {
        if (list == null) {
            list = zzbic;
        }
        return new LocationResult(list);
    }

    LocationResult(List<Location> list) {
        this.zzbid = list;
    }

    public final Location getLastLocation() {
        int n = this.zzbid.size();
        if (n == 0) {
            return null;
        }
        return this.zzbid.get(n - 1);
    }

    @NonNull
    public final List<Location> getLocations() {
        return this.zzbid;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationResult locationResult = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, locationResult.getLocations(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final int hashCode() {
        int n = 17;
        Iterator<Location> iterator = this.zzbid.iterator();
        while (iterator.hasNext()) {
            long l = iterator.next().getTime();
            int n2 = (int)(l ^ l >>> 32);
            n = n * 31 + n2;
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof LocationResult)) {
            return false;
        }
        LocationResult locationResult = (LocationResult)((Object)object);
        if (locationResult.zzbid.size() != this.zzbid.size()) {
            return false;
        }
        Iterator<Location> iterator = locationResult.zzbid.iterator();
        Iterator<Location> iterator2 = this.zzbid.iterator();
        while (iterator.hasNext()) {
            Location location = iterator2.next();
            Location location2 = iterator.next();
            if (location.getTime() == location2.getTime()) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        String string = String.valueOf(this.zzbid);
        return new StringBuilder(27 + String.valueOf(string).length()).append("LocationResult[locations: ").append(string).append("]").toString();
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    public static LocationResult extractResult(Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }
}

