/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzbzv;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public final class zzbzu
extends zza
implements Geofence {
    private final String zzcjq;
    private final long zzhzz;
    private final short zzhxb;
    private final double zzhxc;
    private final double zzhxd;
    private final float zzhxe;
    private final int zzhwz;
    private final int zzhxf;
    private final int zzhxg;
    public static final Parcelable.Creator<zzbzu> CREATOR = new zzbzv();

    public zzbzu(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        float f2;
        String string2 = string;
        if (string2 == null || string2.length() > 100) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "requestId is null or too long: ".concat(string3) : new String("requestId is null or too long: "));
        }
        float f3 = f;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f3).toString());
        }
        double d3 = d2;
        double d4 = d;
        if (d4 > 90.0 || d4 < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d4).toString());
        }
        if (d3 > 180.0 || d3 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d3).toString());
        }
        int n4 = n;
        int n5 = n4 & 7;
        if (n5 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n4).toString());
        }
        n = n5;
        this.zzhxb = s;
        this.zzcjq = string;
        this.zzhxc = d;
        this.zzhxd = d2;
        this.zzhxe = f;
        this.zzhzz = l;
        this.zzhwz = n;
        this.zzhxf = n2;
        this.zzhxg = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zzcjq;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzbzu zzbzu2 = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)zzbzu2.getRequestId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (long)zzbzu2.zzhzz);
        zzd.zza((Parcel)parcel2, (int)3, (short)zzbzu2.zzhxb);
        zzd.zza((Parcel)parcel2, (int)4, (double)zzbzu2.zzhxc);
        zzd.zza((Parcel)parcel2, (int)5, (double)zzbzu2.zzhxd);
        zzd.zza((Parcel)parcel2, (int)6, (float)zzbzu2.zzhxe);
        zzd.zzc((Parcel)parcel2, (int)7, (int)zzbzu2.zzhwz);
        zzd.zzc((Parcel)parcel2, (int)8, (int)zzbzu2.zzhxf);
        zzd.zzc((Parcel)parcel2, (int)9, (int)zzbzu2.zzhxg);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public static zzbzu zzn(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzbzu zzbzu2 = (zzbzu)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzbzu2;
    }

    public final String toString() {
        String string;
        Object[] objectArray = new Object[9];
        switch (this.zzhxb) {
            case 1: {
                string = "CIRCLE";
                break;
            }
            default: {
                string = null;
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zzcjq;
        objectArray[2] = this.zzhwz;
        objectArray[3] = this.zzhxc;
        objectArray[4] = this.zzhxd;
        objectArray[5] = Float.valueOf(this.zzhxe);
        objectArray[6] = this.zzhxf / 1000;
        objectArray[7] = this.zzhxg;
        objectArray[8] = this.zzhzz;
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzhxc);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzhxd);
        n = n * 31 + (int)(l ^ l >>> 32);
        n = n * 31 + Float.floatToIntBits(this.zzhxe);
        n = n * 31 + this.zzhxb;
        return n * 31 + this.zzhwz;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzbzu)) {
            return false;
        }
        zzbzu zzbzu2 = (zzbzu)object;
        if (this.zzhxe != zzbzu2.zzhxe) {
            return false;
        }
        if (this.zzhxc != zzbzu2.zzhxc) {
            return false;
        }
        if (this.zzhxd != zzbzu2.zzhxd) {
            return false;
        }
        return this.zzhxb == zzbzu2.zzhxb;
    }
}

