/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.zzbzu;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzcjq = null;
        private int zzhwz = 0;
        private long zzhxa = Long.MIN_VALUE;
        private short zzhxb = (short)-1;
        private double zzhxc;
        private double zzhxd;
        private float zzhxe;
        private int zzhxf = 0;
        private int zzhxg = -1;

        public Builder() {
        }

        public final Builder setRequestId(String string) {
            this.zzcjq = string;
            return this;
        }

        public final Builder setTransitionTypes(int n) {
            this.zzhwz = n;
            return this;
        }

        public final Builder setExpirationDuration(long l) {
            this.zzhxa = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public final Builder setCircularRegion(double d, double d2, float f) {
            this.zzhxb = 1;
            this.zzhxc = d;
            this.zzhxd = d2;
            this.zzhxe = f;
            return this;
        }

        public final Builder setNotificationResponsiveness(int n) {
            this.zzhxf = n;
            return this;
        }

        public final Builder setLoiteringDelay(int n) {
            this.zzhxg = n;
            return this;
        }

        public final Geofence build() {
            if (this.zzcjq == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzhwz == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzhwz & 4) != 0 && this.zzhxg < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzhxa == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzhxb == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzhxf < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new zzbzu(this.zzcjq, this.zzhwz, 1, this.zzhxc, this.zzhxd, this.zzhxe, this.zzhxa, this.zzhxf, this.zzhxg);
        }
    }
}

