/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbzu;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzi;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends zza {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzi();
    private final List<zzbzu> zzhxk;
    private final int zzhxl;
    private final String mTag;

    GeofencingRequest(List<zzbzu> list, int n, String string) {
        this.zzhxk = list;
        this.zzhxl = n;
        this.mTag = string;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzhxk);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzhxl;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GeofencingRequest geofencingRequest = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, geofencingRequest.zzhxk, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)2, (int)geofencingRequest.getInitialTrigger());
        zzd.zza((Parcel)parcel2, (int)3, (String)geofencingRequest.mTag, (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeofencingRequest[");
        stringBuilder.append("geofences=");
        stringBuilder.append(this.zzhxk);
        int n = this.zzhxl;
        stringBuilder.append(new StringBuilder(30).append(", initialTrigger=").append(n).append(", ").toString());
        String string = String.valueOf(this.mTag);
        stringBuilder.append(string.length() != 0 ? "tag=".concat(string) : new String("tag="));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final List<zzbzu> zzhxk = new ArrayList<zzbzu>();
        private int zzhxl = 5;
        private String mTag = "";

        public Builder() {
        }

        public final Builder addGeofence(Geofence geofence) {
            zzbp.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzbp.zzb((boolean)(geofence instanceof zzbzu), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzhxk.add((zzbzu)geofence);
            return this;
        }

        public final Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public final Builder setInitialTrigger(int n) {
            this.zzhxl = n & 7;
            return this;
        }

        public final GeofencingRequest build() {
            zzbp.zzb((!this.zzhxk.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzhxk, this.zzhxl, this.mTag);
        }
    }
}

