/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public final class zzcfs
extends zzbfm
implements Geofence {
    private final String zzcrt;
    private final long zzimd;
    private final short zzija;
    private final double zzijb;
    private final double zzijc;
    private final float zzijd;
    private final int zziiy;
    private final int zzije;
    private final int zzijf;
    public static final Parcelable.Creator<zzcfs> CREATOR = new zzcft();

    public zzcfs(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        float f2;
        String string2 = string;
        if (string2 == null || string2.length() > 100) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "requestId is null or too long: ".concat(string3) : new String("requestId is null or too long: "));
        }
        float f3 = f;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f3).toString());
        }
        double d3 = d2;
        double d4 = d;
        if (d4 > 90.0 || d4 < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d4).toString());
        }
        if (d3 > 180.0 || d3 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d3).toString());
        }
        int n4 = n;
        int n5 = n4 & 7;
        if (n5 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n4).toString());
        }
        n = n5;
        this.zzija = s;
        this.zzcrt = string;
        this.zzijb = d;
        this.zzijc = d2;
        this.zzijd = f;
        this.zzimd = l;
        this.zziiy = n;
        this.zzije = n2;
        this.zzijf = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zzcrt;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzcfs zzcfs2 = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)1, (String)zzcfs2.getRequestId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)zzcfs2.zzimd);
        zzbfp.zza((Parcel)parcel2, (int)3, (short)zzcfs2.zzija);
        zzbfp.zza((Parcel)parcel2, (int)4, (double)zzcfs2.zzijb);
        zzbfp.zza((Parcel)parcel2, (int)5, (double)zzcfs2.zzijc);
        zzbfp.zza((Parcel)parcel2, (int)6, (float)zzcfs2.zzijd);
        zzbfp.zzc((Parcel)parcel2, (int)7, (int)zzcfs2.zziiy);
        zzbfp.zzc((Parcel)parcel2, (int)8, (int)zzcfs2.zzije);
        zzbfp.zzc((Parcel)parcel2, (int)9, (int)zzcfs2.zzijf);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public static zzcfs zzp(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzcfs zzcfs2 = (zzcfs)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzcfs2;
    }

    public final String toString() {
        String string;
        Object[] objectArray = new Object[9];
        switch (this.zzija) {
            case 1: {
                string = "CIRCLE";
                break;
            }
            default: {
                string = null;
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zzcrt.replaceAll("\\p{C}", "?");
        objectArray[2] = this.zziiy;
        objectArray[3] = this.zzijb;
        objectArray[4] = this.zzijc;
        objectArray[5] = Float.valueOf(this.zzijd);
        objectArray[6] = this.zzije / 1000;
        objectArray[7] = this.zzijf;
        objectArray[8] = this.zzimd;
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzijb);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzijc);
        n = n * 31 + (int)(l ^ l >>> 32);
        n = n * 31 + Float.floatToIntBits(this.zzijd);
        n = n * 31 + this.zzija;
        return n * 31 + this.zziiy;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzcfs)) {
            return false;
        }
        zzcfs zzcfs2 = (zzcfs)object;
        if (this.zzijd != zzcfs2.zzijd) {
            return false;
        }
        if (this.zzijb != zzcfs2.zzijb) {
            return false;
        }
        if (this.zzijc != zzcfs2.zzijc) {
            return false;
        }
        return this.zzija == zzcfs2.zzija;
    }
}

