/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public class ActivityTransition
extends zzbgl {
    public static final int ACTIVITY_TRANSITION_ENTER = 0;
    public static final int ACTIVITY_TRANSITION_EXIT = 1;
    public static final Parcelable.Creator<ActivityTransition> CREATOR = new zzc();
    private final int zza;
    private final int zzb;

    @Hide
    ActivityTransition(int n, int n2) {
        this.zza = n;
        this.zzb = n2;
    }

    public int getActivityType() {
        return this.zza;
    }

    public int getTransitionType() {
        return this.zzb;
    }

    @Hide
    public static void zza(int n) {
        zzbq.zzb((n >= 0 && n <= 1 ? 1 : 0) != 0, (Object)new StringBuilder(41).append("Transition type ").append(n).append(" is not valid.").toString());
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivityTransition)) {
            return false;
        }
        ActivityTransition activityTransition = (ActivityTransition)((Object)object);
        return this.zza == activityTransition.zza && this.zzb == activityTransition.zzb;
    }

    public String toString() {
        int n = this.zza;
        int n2 = this.zzb;
        return new StringBuilder(75).append("ActivityTransition [mActivityType=").append(n).append(", mTransitionType=").append(n2).append(']').toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransition activityTransition = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)activityTransition.getActivityType());
        zzbgo.zza((Parcel)parcel2, (int)2, (int)activityTransition.getTransitionType());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private int zza = -1;
        private int zzb = -1;

        public Builder() {
        }

        public Builder setActivityType(int n) {
            DetectedActivity.zza(n);
            this.zza = n;
            return this;
        }

        public Builder setActivityTransition(int n) {
            ActivityTransition.zza(n);
            this.zzb = n;
            return this;
        }

        public ActivityTransition build() {
            zzbq.zza((this.zza != -1 ? 1 : 0) != 0, (Object)"Activity type not set.");
            zzbq.zza((this.zzb != -1 ? 1 : 0) != 0, (Object)"Activity transition type not set.");
            return new ActivityTransition(this.zza, this.zzb);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedActivityTransition {
    }
}

