/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzc;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public class ActivityTransition
extends zzbgl {
    public static final int ACTIVITY_TRANSITION_ENTER = 0;
    public static final int ACTIVITY_TRANSITION_EXIT = 1;
    public static final Parcelable.Creator<ActivityTransition> CREATOR = new zzc();
    private final int zziqw;
    private final int zziqx;

    @Hide
    ActivityTransition(int n, int n2) {
        this.zziqw = n;
        this.zziqx = n2;
    }

    public int getActivityType() {
        return this.zziqw;
    }

    public int getTransitionType() {
        return this.zziqx;
    }

    @Hide
    public static void zzeh(int n) {
        zzbq.checkArgument((n >= 0 && n <= 1 ? 1 : 0) != 0, (Object)new StringBuilder(41).append("Transition type ").append(n).append(" is not valid.").toString());
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zziqw, this.zziqx});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivityTransition)) {
            return false;
        }
        ActivityTransition activityTransition = (ActivityTransition)((Object)object);
        return this.zziqw == activityTransition.zziqw && this.zziqx == activityTransition.zziqx;
    }

    public String toString() {
        int n = this.zziqw;
        int n2 = this.zziqx;
        return new StringBuilder(75).append("ActivityTransition [mActivityType=").append(n).append(", mTransitionType=").append(n2).append(']').toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransition activityTransition = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)activityTransition.getActivityType());
        zzbgo.zzc((Parcel)parcel2, (int)2, (int)activityTransition.getTransitionType());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private int zziqw = -1;
        private int zziqx = -1;

        public Builder() {
        }

        public Builder setActivityType(int n) {
            DetectedActivity.zzei(n);
            this.zziqw = n;
            return this;
        }

        public Builder setActivityTransition(int n) {
            ActivityTransition.zzeh(n);
            this.zziqx = n;
            return this;
        }

        public ActivityTransition build() {
            zzbq.zza((this.zziqw != -1 ? 1 : 0) != 0, (Object)"Activity type not set.");
            zzbq.zza((this.zziqx != -1 ? 1 : 0) != 0, (Object)"Activity transition type not set.");
            return new ActivityTransition(this.zziqw, this.zziqx);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SupportedActivityTransition {
    }
}

