/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzdf;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbj;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgr;
import com.google.android.gms.internal.zzcgs;
import com.google.android.gms.internal.zzchl;
import com.google.android.gms.internal.zzchz;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.zzl;
import com.google.android.gms.location.zzm;
import com.google.android.gms.location.zzn;
import com.google.android.gms.location.zzo;
import com.google.android.gms.location.zzp;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class FusedLocationProviderClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    public static final String KEY_VERTICAL_ACCURACY = "verticalAccuracy";

    @Hide
    public FusedLocationProviderClient(@NonNull Context context) {
        super(context, LocationServices.API, null, (zzda)new zzg());
    }

    @Hide
    public FusedLocationProviderClient(@NonNull Activity activity) {
        super(activity, LocationServices.API, null, (zzda)new zzg());
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Location> getLastLocation() {
        return this.zza(new zzl(this));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<LocationAvailability> getLocationAvailability() {
        return this.zza(new zzm(this));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationCallback locationCallback, @Nullable Looper looper) {
        zzchl zzchl2 = zzchl.zza(locationRequest);
        Looper looper2 = looper;
        LocationCallback locationCallback2 = locationCallback;
        zzchl zzchl3 = zzchl2;
        FusedLocationProviderClient fusedLocationProviderClient = this;
        zzci zzci2 = zzcm.zzb((Object)locationCallback2, (Looper)zzchz.zzb(looper2), (String)LocationCallback.class.getSimpleName());
        zzn zzn2 = new zzn(fusedLocationProviderClient, zzci2, zzchl3, zzci2);
        zzo zzo2 = new zzo(fusedLocationProviderClient, zzci2.zzakx());
        return fusedLocationProviderClient.zza(zzn2, zzo2);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        return zzbj.zzb(LocationServices.FusedLocationApi.requestLocationUpdates(this.zzahw(), locationRequest, pendingIntent));
    }

    public Task<Void> removeLocationUpdates(PendingIntent pendingIntent) {
        return zzbj.zzb(LocationServices.FusedLocationApi.removeLocationUpdates(this.zzahw(), pendingIntent));
    }

    public Task<Void> removeLocationUpdates(LocationCallback locationCallback) {
        return zzdf.zza((Task)this.zza(zzcm.zzb((Object)locationCallback, (String)LocationCallback.class.getSimpleName())));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockMode(boolean bl) {
        return zzbj.zzb(LocationServices.FusedLocationApi.setMockMode(this.zzahw(), bl));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Task<Void> setMockLocation(Location location) {
        return zzbj.zzb(LocationServices.FusedLocationApi.setMockLocation(this.zzahw(), location));
    }

    public Task<Void> flushLocations() {
        return zzbj.zzb(LocationServices.FusedLocationApi.flushLocations(this.zzahw()));
    }

    private final zzcgr zzc(TaskCompletionSource<Boolean> taskCompletionSource) {
        return new zzp(this, taskCompletionSource);
    }

    static /* synthetic */ zzcgr zza(FusedLocationProviderClient fusedLocationProviderClient, TaskCompletionSource taskCompletionSource) {
        return fusedLocationProviderClient.zzc((TaskCompletionSource<Boolean>)taskCompletionSource);
    }

    static final class zza
    extends zzcgs {
        private final TaskCompletionSource<Void> zzejm;

        public zza(TaskCompletionSource<Void> taskCompletionSource) {
            this.zzejm = taskCompletionSource;
        }

        @Override
        public final void zza(zzcgl zzcgl2) {
            TaskCompletionSource<Void> taskCompletionSource = this.zzejm;
            zzdf.zza((Status)zzcgl2.getStatus(), null, taskCompletionSource);
        }
    }
}

