/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzchp;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzq;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends zzbgl {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzq();
    private final List<zzchp> zzirz;
    private final int zzisa;
    @Hide
    private final String mTag;

    GeofencingRequest(List<zzchp> list, int n, String string) {
        this.zzirz = list;
        this.zzisa = n;
        this.mTag = string;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzirz);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzisa;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GeofencingRequest geofencingRequest = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, geofencingRequest.zzirz, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)2, (int)geofencingRequest.getInitialTrigger());
        zzbgo.zza((Parcel)parcel2, (int)3, (String)geofencingRequest.mTag, (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeofencingRequest[");
        stringBuilder.append("geofences=");
        stringBuilder.append(this.zzirz);
        int n = this.zzisa;
        stringBuilder.append(new StringBuilder(30).append(", initialTrigger=").append(n).append(", ").toString());
        String string = String.valueOf(this.mTag);
        stringBuilder.append(string.length() != 0 ? "tag=".concat(string) : new String("tag="));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final List<zzchp> zzirz = new ArrayList<zzchp>();
        private int zzisa = 5;
        private String mTag = "";

        public Builder() {
        }

        public final Builder addGeofence(Geofence geofence) {
            zzbq.checkNotNull((Object)geofence, (Object)"geofence can't be null.");
            zzbq.checkArgument((boolean)(geofence instanceof zzchp), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzirz.add((zzchp)geofence);
            return this;
        }

        public final Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public final Builder setInitialTrigger(int n) {
            this.zzisa = n & 7;
            return this;
        }

        public final GeofencingRequest build() {
            zzbq.checkArgument((!this.zzirz.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzirz, this.zzisa, this.mTag);
        }
    }
}

