/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.ActivityTransitionEvent;
import com.google.android.gms.location.zzg;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionResultCreator")
public class ActivityTransitionResult
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ActivityTransitionResult> CREATOR = new zzg();
    @SafeParcelable.Field(id=1, getter="getTransitionEvents")
    private final List<ActivityTransitionEvent> zzn;

    @SafeParcelable.Constructor
    public ActivityTransitionResult(@SafeParcelable.Param(id=1) List<ActivityTransitionEvent> list) {
        Preconditions.checkNotNull(list, (Object)"transitionEvents list can't be null.");
        List<ActivityTransitionEvent> list2 = list;
        if (!list2.isEmpty()) {
            for (int i = 1; i < list2.size(); ++i) {
                Preconditions.checkArgument((list2.get(i).getElapsedRealTimeNanos() >= list2.get(i - 1).getElapsedRealTimeNanos() ? 1 : 0) != 0);
            }
        }
        this.zzn = Collections.unmodifiableList(list);
    }

    public List<ActivityTransitionEvent> getTransitionEvents() {
        return this.zzn;
    }

    public static boolean hasResult(@Nullable Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_RESULT");
    }

    @Nullable
    public static ActivityTransitionResult extractResult(Intent intent) {
        if (!ActivityTransitionResult.hasResult(intent)) {
            return null;
        }
        return (ActivityTransitionResult)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_RESULT", CREATOR);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransitionResult activityTransitionResult = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)1, activityTransitionResult.getTransitionEvents(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        return this.zzn.equals(((ActivityTransitionResult)((Object)object)).zzn);
    }

    public int hashCode() {
        return this.zzn.hashCode();
    }
}

