/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzaa;
import com.google.android.gms.location.zzaj;
import java.util.Arrays;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationAvailabilityCreator")
public final class LocationAvailability
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @Deprecated
    @SafeParcelable.Field(id=1, defaultValueUnchecked="LocationAvailability.STATUS_UNKNOWN")
    private int zzar;
    @Deprecated
    @SafeParcelable.Field(id=2, defaultValueUnchecked="LocationAvailability.STATUS_UNKNOWN")
    private int zzas;
    @SafeParcelable.Field(id=3, defaultValueUnchecked="0")
    private long zzat;
    @SafeParcelable.Field(id=4, defaultValueUnchecked="LocationAvailability.STATUS_UNSUCCESSFUL")
    private int zzau;
    @SafeParcelable.Field(id=5)
    private zzaj[] zzav;
    public static final Parcelable.Creator<LocationAvailability> CREATOR = new zzaa();

    @SafeParcelable.Constructor
    LocationAvailability(@SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) int n3, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=5) zzaj[] zzajArray) {
        this.zzau = n;
        this.zzar = n2;
        this.zzas = n3;
        this.zzat = l;
        this.zzav = zzajArray;
    }

    public final boolean isLocationAvailable() {
        return this.zzau < 1000;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationAvailability locationAvailability = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)locationAvailability.zzar);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)locationAvailability.zzas);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)locationAvailability.zzat);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)locationAvailability.zzau);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)5, (Parcelable[])locationAvailability.zzav, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzau, this.zzar, this.zzas, this.zzat, this.zzav});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        LocationAvailability locationAvailability = (LocationAvailability)((Object)object);
        return this.zzar == locationAvailability.zzar && this.zzas == locationAvailability.zzas && this.zzat == locationAvailability.zzat && this.zzau == locationAvailability.zzau && Arrays.equals((Object[])this.zzav, (Object[])locationAvailability.zzav);
    }

    public final String toString() {
        boolean bl = this.isLocationAvailable();
        return new StringBuilder(48).append("LocationAvailability[isLocationAvailable: ").append(bl).append("]").toString();
    }

    public static boolean hasLocationAvailability(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
    }

    public static LocationAvailability extractLocationAvailability(Intent intent) {
        if (!LocationAvailability.hasLocationAvailability(intent)) {
            return null;
        }
        return (LocationAvailability)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_AVAILABILITY");
    }
}

