/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzae;
import com.google.android.gms.location.zzag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationSettingsRequestCreator")
public final class LocationSettingsRequest
extends AbstractSafeParcelable {
    @SafeParcelable.Field(id=1, getter="getLocationRequests")
    private final List<LocationRequest> zzbg;
    @SafeParcelable.Field(id=2, getter="alwaysShow", defaultValue="false")
    private final boolean zzbh;
    @SafeParcelable.Field(id=3, getter="needBle")
    private final boolean zzbi;
    @SafeParcelable.Field(id=5, getter="getConfiguration")
    private zzae zzbj;
    public static final Parcelable.Creator<LocationSettingsRequest> CREATOR = new zzag();

    @SafeParcelable.Constructor
    LocationSettingsRequest(@SafeParcelable.Param(id=1) List<LocationRequest> list, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @SafeParcelable.Param(id=5) zzae zzae2) {
        this.zzbg = list;
        this.zzbh = bl;
        this.zzbi = bl2;
        this.zzbj = zzae2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationSettingsRequest locationSettingsRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)1, Collections.unmodifiableList(locationSettingsRequest.zzbg), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)locationSettingsRequest.zzbh);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)locationSettingsRequest.zzbi);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)locationSettingsRequest.zzbj, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private final ArrayList<LocationRequest> zzbk = new ArrayList();
        private boolean zzbh = false;
        private boolean zzbi = false;
        private zzae zzbj = null;

        public final Builder addLocationRequest(@NonNull LocationRequest locationRequest) {
            if (locationRequest != null) {
                this.zzbk.add(locationRequest);
            }
            return this;
        }

        public final Builder addAllLocationRequests(Collection<LocationRequest> collection) {
            for (LocationRequest locationRequest : collection) {
                if (locationRequest == null) continue;
                this.zzbk.add(locationRequest);
            }
            return this;
        }

        public final Builder setAlwaysShow(boolean bl) {
            this.zzbh = bl;
            return this;
        }

        public final Builder setNeedBle(boolean bl) {
            this.zzbi = bl;
            return this;
        }

        public final LocationSettingsRequest build() {
            return new LocationSettingsRequest(this.zzbk, this.zzbh, this.zzbi, null);
        }
    }
}

