/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzk;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityRecognitionResultCreator")
public class ActivityRecognitionResult
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<ActivityRecognitionResult> CREATOR;
    @SafeParcelable.Field(id=1)
    List<DetectedActivity> zza;
    @SafeParcelable.Field(id=2)
    long zzb;
    @SafeParcelable.Field(id=3)
    long zzc;
    @SafeParcelable.Field(id=4)
    int zzd;
    @SafeParcelable.Field(id=5)
    @Nullable
    Bundle zze;

    public ActivityRecognitionResult(@RecentlyNonNull List<DetectedActivity> list, long l, long l2) {
        this(list, l, l2, 0, null);
    }

    @VisibleForTesting
    public ActivityRecognitionResult(@RecentlyNonNull DetectedActivity detectedActivity, long l, long l2) {
        this(Collections.singletonList(detectedActivity), l, l2, 0, null);
    }

    public static boolean hasResult(@Nullable Intent object) {
        if (object == null) {
            return false;
        }
        if (object.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT")) {
            return true;
        }
        return (object = ActivityRecognitionResult.zza((Intent)object)) != null && !object.isEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @RecentlyNullable
    public static ActivityRecognitionResult extractResult(@RecentlyNonNull Intent object) {
        void var1_2;
        if (!ActivityRecognitionResult.hasResult((Intent)object)) {
            Object var1_1 = null;
        } else {
            Bundle bundle = object.getExtras();
            if (bundle == null) {
                Object var1_4 = null;
            } else {
                Object object2 = bundle.get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
                if (object2 instanceof byte[]) {
                    ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)SafeParcelableSerializer.deserializeFromBytes((byte[])((byte[])object2), CREATOR);
                } else if (object2 instanceof ActivityRecognitionResult) {
                    ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)((Object)object2);
                } else {
                    Object var1_8 = null;
                }
            }
        }
        if (var1_2 != null) {
            return var1_2;
        }
        if ((object = ActivityRecognitionResult.zza((Intent)object)) != null && !object.isEmpty()) {
            return (ActivityRecognitionResult)((Object)object.get(object.size() + -1));
        }
        return null;
    }

    @RecentlyNonNull
    public DetectedActivity getMostProbableActivity() {
        return this.zza.get(0);
    }

    public int getActivityConfidence(int n) {
        for (DetectedActivity detectedActivity : ((ActivityRecognitionResult)((Object)this)).zza) {
            if (detectedActivity.getType() != n) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    @RecentlyNonNull
    public List<DetectedActivity> getProbableActivities() {
        return this.zza;
    }

    public long getTime() {
        return this.zzb;
    }

    public long getElapsedRealtimeMillis() {
        return this.zzc;
    }

    @RecentlyNonNull
    public String toString() {
        String string = String.valueOf(((ActivityRecognitionResult)((Object)string2)).zza);
        long l = ((ActivityRecognitionResult)((Object)string2)).zzb;
        long l2 = ((ActivityRecognitionResult)((Object)string2)).zzc;
        String string2 = String.valueOf(string);
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 124);
        stringBuilder.append("ActivityRecognitionResult [probableActivities=");
        stringBuilder.append(string);
        stringBuilder.append(", timeMillis=");
        stringBuilder.append(l);
        stringBuilder.append(", elapsedRealtimeMillis=");
        stringBuilder.append(l2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @ShowFirstParty
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        object = (ActivityRecognitionResult)((Object)object);
        return this.zzb == ((ActivityRecognitionResult)((Object)object)).zzb && this.zzc == ((ActivityRecognitionResult)((Object)object)).zzc && this.zzd == ((ActivityRecognitionResult)((Object)object)).zzd && Objects.equal(this.zza, ((ActivityRecognitionResult)((Object)object)).zza) && ActivityRecognitionResult.zzb(this.zze, ((ActivityRecognitionResult)((Object)object)).zze);
    }

    @ShowFirstParty
    public final int hashCode() {
        Object[] objectArray = new Object[]{this.zzb, this.zzc, this.zzd, this.zza, this.zze};
        return Objects.hashCode((Object[])objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @ShowFirstParty
    @SafeParcelable.Constructor
    public ActivityRecognitionResult(@SafeParcelable.Param(id=1) @RecentlyNonNull List<DetectedActivity> list, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=4) int n, @Nullable @SafeParcelable.Param(id=5) Bundle bundle) {
        boolean bl = list != null ? list.size() > 0 : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Must have at least 1 detected activity");
        bl = l > 0L ? l2 > 0L : false;
        Preconditions.checkArgument((boolean)bl, (Object)"Must set times");
        this.zza = list;
        this.zzb = l;
        this.zzc = l2;
        this.zzd = n;
        this.zze = bundle;
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)1, this.zza, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)2, (long)this.zzb);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)3, (long)this.zzc);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.zzd);
        SafeParcelWriter.writeBundle((Parcel)parcel, (int)5, (Bundle)this.zze, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    static {
        zzk zzk2;
        CREATOR = zzk2 = new zzk();
    }

    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNullable
    public static List<ActivityRecognitionResult> zza(@RecentlyNonNull Intent intent) {
        if (intent == null || !intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST")) {
            return null;
        }
        return SafeParcelableSerializer.deserializeIterableFromIntentExtra((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST", CREATOR);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzb(@Nullable Bundle bundle, @Nullable Bundle bundle2) {
        if (bundle == null) {
            return bundle2 == null;
        }
        if (bundle2 == null) {
            return false;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            if (!bundle2.containsKey(string)) {
                return false;
            }
            Object object = bundle.get(string);
            Object object2 = bundle2.get(string);
            if (object == null) {
                if (object2 == null) continue;
                return false;
            }
            if (object instanceof Bundle) {
                if (ActivityRecognitionResult.zzb(bundle.getBundle(string), bundle2.getBundle(string))) continue;
                return false;
            }
            if (object.getClass().isArray()) {
                if (object2 == null || !object2.getClass().isArray()) {
                    return false;
                }
                int n = Array.getLength(object);
                if (n != Array.getLength(object2)) return false;
                for (int i = 0; i < n; ++i) {
                    if (Objects.equal((Object)Array.get(object, i), (Object)Array.get(object2, i))) continue;
                    return false;
                }
                continue;
            }
            if (object.equals(object2)) continue;
            return false;
        }
        return true;
    }
}

