/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.ClientIdentity;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zzn;
import com.google.android.gms.location.zzo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionRequestCreator")
public class ActivityTransitionRequest
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<ActivityTransitionRequest> CREATOR;
    @RecentlyNonNull
    public static final Comparator<ActivityTransition> IS_SAME_TRANSITION;
    @SafeParcelable.Field(id=1, getter="getActivityTransitions")
    private final List<ActivityTransition> zza;
    @SafeParcelable.Field(id=2, getter="getTag")
    @Nullable
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getClients")
    private final List<ClientIdentity> zzc;
    @SafeParcelable.Field(id=4, getter="getContextAttributionTag", defaultValueUnchecked="null")
    @Nullable
    private String zzd;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public ActivityTransitionRequest(@SafeParcelable.Param(id=1) @RecentlyNonNull List<ActivityTransition> list, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable List<ClientIdentity> list2, @SafeParcelable.Param(id=4) @Nullable String string2) {
        void var4_7;
        void var1_3;
        void var3_6;
        void var2_5;
        Preconditions.checkNotNull(list, (Object)"transitions can't be null");
        boolean bl = list.size() > 0;
        Preconditions.checkArgument((boolean)bl, (Object)"transitions can't be empty.");
        Preconditions.checkNotNull(list);
        TreeSet<ActivityTransition> treeSet = new TreeSet<ActivityTransition>(IS_SAME_TRANSITION);
        for (ActivityTransition activityTransition : list) {
            boolean bl2 = treeSet.add(activityTransition);
            Object[] objectArray = new Object[]{activityTransition};
            Preconditions.checkArgument((boolean)bl2, (Object)String.format("Found duplicated transition: %s.", objectArray));
        }
        this.zza = Collections.unmodifiableList(list);
        this.zzb = var2_5;
        if (var3_6 == null) {
            List list3 = Collections.emptyList();
        } else {
            List list4 = Collections.unmodifiableList(var3_6);
        }
        this.zzc = var1_3;
        this.zzd = var4_7;
    }

    public ActivityTransitionRequest(@RecentlyNonNull List<ActivityTransition> list) {
        this(list, null, null, null);
    }

    public void serializeToIntentExtra(@RecentlyNonNull Intent intent) {
        Preconditions.checkNotNull((Object)intent);
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)this, (Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_REQUEST");
    }

    public void writeToParcel(@RecentlyNonNull Parcel parcel, int n) {
        Preconditions.checkNotNull((Object)parcel);
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)1, this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel, (int)3, this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        object = (ActivityTransitionRequest)((Object)object);
        return Objects.equal(this.zza, ((ActivityTransitionRequest)((Object)object)).zza) && Objects.equal((Object)this.zzb, (Object)((ActivityTransitionRequest)((Object)object)).zzb) && Objects.equal((Object)this.zzd, (Object)((ActivityTransitionRequest)((Object)object)).zzd) && Objects.equal(this.zzc, ((ActivityTransitionRequest)((Object)object)).zzc);
    }

    @RecentlyNonNull
    public String toString() {
        String string = String.valueOf(object.zza);
        String string2 = object.zzb;
        String string3 = String.valueOf(object.zzc);
        Object object = object.zzd;
        String string4 = String.valueOf(string);
        int n = string4.length();
        String string5 = String.valueOf(string2);
        int n2 = string5.length();
        String string6 = String.valueOf(string3);
        int n3 = string6.length();
        String string7 = String.valueOf(object);
        int n4 = string7.length();
        StringBuilder stringBuilder = new StringBuilder(n + 79 + n2 + n3 + n4);
        stringBuilder.append("ActivityTransitionRequest [mTransitions=");
        stringBuilder.append(string);
        stringBuilder.append(", mTag='");
        stringBuilder.append(string2);
        stringBuilder.append("', mClients=");
        stringBuilder.append(string3);
        stringBuilder.append(", mAttributionTag=");
        stringBuilder.append((String)object);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n;
        int n2 = ((ActivityTransitionRequest)((Object)string2)).zza.hashCode() * 31;
        String string = ((ActivityTransitionRequest)((Object)string2)).zzb;
        int n3 = string != null ? string.hashCode() : 0;
        n2 = (n2 + n3) * 31;
        List<ClientIdentity> list = ((ActivityTransitionRequest)((Object)string2)).zzc;
        int n4 = list != null ? list.hashCode() : 0;
        n4 = (n2 + n4) * 31;
        String string2 = ((ActivityTransitionRequest)((Object)string2)).zzd;
        if (string2 != null) {
            n = string2.hashCode();
            return n4 + n;
        }
        n = 0;
        return n4 + n;
    }

    static {
        Object object = new zzo();
        CREATOR = object;
        IS_SAME_TRANSITION = object = new zzn();
    }

    @RecentlyNonNull
    public final ActivityTransitionRequest zza(@Nullable String string) {
        this.zzd = string;
        return this;
    }
}

