/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzbs;
import com.google.android.gms.location.zzbr;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="RemoveGeofencingRequestCreator")
public final class zzbq
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzbq> CREATOR;
    @SafeParcelable.Field(id=1, getter="getGeofenceIds")
    private final List<String> zza;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getPendingIntent")
    private final PendingIntent zzb;
    @SafeParcelable.Field(id=3, getter="getTag", defaultValue="")
    private final String zzc;

    public static zzbq zza(List<String> list) {
        Preconditions.checkNotNull(list, (Object)"geofence can't be null.");
        Preconditions.checkArgument((boolean)(list.isEmpty() ^ true), (Object)"Geofences must contains at least one id.");
        zzbq zzbq2 = new zzbq(list, null, "");
        return zzbq2;
    }

    public static zzbq zzb(PendingIntent pendingIntent) {
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent can not be null.");
        zzbq zzbq2 = new zzbq(null, pendingIntent, "");
        return zzbq2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeStringList((Parcel)parcel, (int)1, this.zza, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.zzb, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    zzbq(@SafeParcelable.Param(id=1) @Nullable List<String> list, @SafeParcelable.Param(id=2) @Nullable PendingIntent pendingIntent, @SafeParcelable.Param(id=3) String string) {
        list = list == null ? zzbs.zzi() : zzbs.zzj(list);
        this.zza = list;
        this.zzb = pendingIntent;
        this.zzc = string;
    }

    static {
        zzbr zzbr2;
        CREATOR = zzbr2 = new zzbr();
    }
}

