/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.location.ActivityTransitionRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.SleepSegmentRequest;
import com.google.android.gms.location.zzc;
import com.google.android.gms.location.zzd;
import com.google.android.gms.location.zze;
import com.google.android.gms.location.zzf;
import com.google.android.gms.location.zzg;
import com.google.android.gms.location.zzh;
import com.google.android.gms.location.zzu;
import com.google.android.gms.tasks.Task;

public class ActivityRecognitionClient
extends GoogleApi<Api.ApiOptions.NoOptions> {
    public static final /* synthetic */ int zza;

    public ActivityRecognitionClient(@NonNull Context context) {
        super(context, LocationServices.API, (Api.ApiOptions)Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public ActivityRecognitionClient(@NonNull Activity activity) {
        super(activity, LocationServices.API, (Api.ApiOptions)Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    @NonNull
    public Task<Void> requestActivityUpdates(long l, @NonNull PendingIntent pendingIntent) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzc zzc2 = new zzc(l, pendingIntent);
        return this.doWrite(builder.run((RemoteCall)zzc2).setMethodKey(2401).build());
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    @NonNull
    public Task<Void> removeActivityUpdates(@NonNull PendingIntent pendingIntent) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zze zze2 = new zze(pendingIntent);
        return this.doWrite(builder.run((RemoteCall)zze2).setMethodKey(2402).build());
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    @NonNull
    public Task<Void> requestActivityTransitionUpdates(@NonNull ActivityTransitionRequest activityTransitionRequest, @NonNull PendingIntent pendingIntent) {
        activityTransitionRequest.zza(this.getContextAttributionTag());
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzf zzf2 = new zzf(activityTransitionRequest, pendingIntent);
        return this.doWrite(builder.run((RemoteCall)zzf2).setMethodKey(2405).build());
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    @NonNull
    public Task<Void> removeActivityTransitionUpdates(@NonNull PendingIntent pendingIntent) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzg zzg2 = new zzg(pendingIntent);
        return this.doWrite(builder.run((RemoteCall)zzg2).setMethodKey(2406).build());
    }

    @RequiresPermission(value="com.google.android.gms.permission.ACTIVITY_RECOGNITION")
    @NonNull
    public Task<Void> requestSleepSegmentUpdates(@NonNull PendingIntent pendingIntent, @NonNull SleepSegmentRequest featureArray) {
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzd zzd2 = new zzd(this, pendingIntent, (SleepSegmentRequest)featureArray);
        pendingIntent = builder.run((RemoteCall)zzd2);
        featureArray = new Feature[]{zzu.zzb};
        return this.doRead(pendingIntent.setFeatures(featureArray).setMethodKey(2410).build());
    }

    @NonNull
    public Task<Void> removeSleepSegmentUpdates(@NonNull PendingIntent pendingIntent) {
        TaskApiCall.Builder builder = TaskApiCall.builder();
        zzh zzh2 = new zzh(pendingIntent);
        return this.doWrite(builder.run((RemoteCall)zzh2).setMethodKey(2411).build());
    }
}

