/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.location.zzbe;

@VisibleForTesting
public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    @NonNull
    public String getRequestId();

    @VisibleForTesting
    public static final class Builder {
        private String zza = null;
        @TransitionTypes
        private int zzb = 0;
        private long zzc = Long.MIN_VALUE;
        private short zzd = (short)-1;
        private double zze;
        private double zzf;
        private float zzg;
        private int zzh = 0;
        private int zzi = -1;

        @NonNull
        public Builder setRequestId(@NonNull String string) {
            this.zza = (String)Preconditions.checkNotNull((Object)string, (Object)"Request ID can't be set to null");
            return this;
        }

        @NonNull
        public Builder setTransitionTypes(@TransitionTypes int n) {
            this.zzb = n;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder setExpirationDuration(long l) {
            if (l < 0L) {
                this.zzc = -1L;
                return this;
            }
            this.zzc = DefaultClock.getInstance().elapsedRealtime() + l;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setCircularRegion(@FloatRange(from=-90.0, to=90.0) double d, @FloatRange(from=-180.0, to=180.0) double d2, @FloatRange(from=0.0, fromInclusive=false) float f) {
            boolean bl = !(d < -90.0) ? d <= 90.0 : false;
            StringBuilder stringBuilder = new StringBuilder(42);
            stringBuilder.append("Invalid latitude: ");
            stringBuilder.append(d);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            bl = !(d2 < -180.0) ? d2 <= 180.0 : false;
            stringBuilder = new StringBuilder(43);
            stringBuilder.append("Invalid longitude: ");
            stringBuilder.append(d2);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            bl = f > 0.0f;
            stringBuilder = new StringBuilder(31);
            stringBuilder.append("Invalid radius: ");
            stringBuilder.append(f);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            this.zzd = 1;
            this.zze = d;
            this.zzf = d2;
            this.zzg = f;
            return this;
        }

        @NonNull
        public Builder setNotificationResponsiveness(@IntRange(from=0L) int n) {
            this.zzh = n;
            return this;
        }

        @NonNull
        public Builder setLoiteringDelay(int n) {
            this.zzi = n;
            return this;
        }

        @NonNull
        public Geofence build() {
            int n;
            long l;
            Object object;
            String string = ((Builder)object).zza;
            if (string == null) {
                object = new IllegalArgumentException("Request ID not set.");
                throw object;
            }
            int n2 = ((Builder)object).zzb;
            if (n2 == 0) {
                object = new IllegalArgumentException("Transitions types not set.");
                throw object;
            }
            if ((n2 & 4) == 0 || ((Builder)object).zzi >= 0) {
                l = ((Builder)object).zzc;
                if (l == Long.MIN_VALUE) {
                    object = new IllegalArgumentException("Expiration not set.");
                    throw object;
                }
                if (((Builder)object).zzd == -1) {
                    object = new IllegalArgumentException("Geofence region not set.");
                    throw object;
                }
                n = ((Builder)object).zzh;
                if (n < 0) {
                    object = new IllegalArgumentException("Notification responsiveness should be nonnegative.");
                    throw object;
                }
            } else {
                object = new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
                throw object;
            }
            zzbe zzbe2 = new zzbe(string, n2, 1, ((Builder)object).zze, ((Builder)object).zzf, ((Builder)object).zzg, l, n, ((Builder)object).zzi);
            return zzbe2;
        }
    }

    public static @interface TransitionTypes {
    }

    public static @interface GeofenceTransition {
    }
}

