/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.location.zzdi;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ParcelableGeofenceCreator")
@VisibleForTesting
public final class zzdh
extends AbstractSafeParcelable
implements Geofence {
    public static final Parcelable.Creator<zzdh> CREATOR;
    @SafeParcelable.Field(id=1, getter="getRequestId")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getExpirationTime")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getType")
    private final short zzc;
    @SafeParcelable.Field(id=4, getter="getLatitude")
    private final double zzd;
    @SafeParcelable.Field(id=5, getter="getLongitude")
    private final double zze;
    @SafeParcelable.Field(id=6, getter="getRadius")
    private final float zzf;
    @SafeParcelable.Field(id=7, getter="getTransitionTypes")
    private final int zzg;
    @SafeParcelable.Field(id=8, getter="getNotificationResponsiveness", defaultValue="0")
    private final int zzh;
    @SafeParcelable.Field(id=9, getter="getLoiteringDelay", defaultValue="-1")
    private final int zzi;

    @Override
    public final double getLatitude() {
        return this.zzd;
    }

    @Override
    public final double getLongitude() {
        return this.zze;
    }

    @Override
    public final float getRadius() {
        return this.zzf;
    }

    @Override
    public final int getLoiteringDelay() {
        return this.zzi;
    }

    @Override
    public final int getNotificationResponsiveness() {
        return this.zzh;
    }

    @Override
    public final int getTransitionTypes() {
        return this.zzg;
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzd);
        long l2 = Double.doubleToLongBits(this.zze);
        return (((((int)(l ^ l >>> 32) + 31) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + Float.floatToIntBits(this.zzf)) * 31 + this.zzc) * 31 + this.zzg;
    }

    @Override
    public final long getExpirationTime() {
        return this.zzb;
    }

    @Override
    public final String getRequestId() {
        return this.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String toString() {
        String string;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[9];
        switch (this.zzc) {
            default: {
                string = "UNKNOWN";
                break;
            }
            case 1: {
                string = "CIRCLE";
                break;
            }
            case -1: {
                string = "INVALID";
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zza.replaceAll("\\p{C}", "?");
        objectArray[2] = this.zzg;
        objectArray[3] = this.zzd;
        objectArray[4] = this.zze;
        objectArray[5] = Float.valueOf(this.zzf);
        objectArray[6] = this.zzh / 1000;
        objectArray[7] = this.zzi;
        objectArray[8] = this.zzb;
        return String.format(locale, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    static {
        zzdi zzdi2;
        CREATOR = zzdi2 = new zzdi();
    }

    @SafeParcelable.Constructor
    public zzdh(@SafeParcelable.Param(id=1) String charSequence, @SafeParcelable.Param(id=7) int n, @SafeParcelable.Param(id=3) short s, @SafeParcelable.Param(id=4) double d, @SafeParcelable.Param(id=5) double d2, @SafeParcelable.Param(id=6) float f, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=8) int n2, @SafeParcelable.Param(id=9) int n3) {
        int n4;
        Object object;
        if (charSequence == null || ((String)charSequence).length() > 100) {
            object = new IllegalArgumentException("requestId is null or too long: ".concat(String.valueOf(charSequence)));
            throw object;
        }
        if (!(f <= 0.0f)) {
            if (d > 90.0 || d < -90.0) {
                ((StringBuilder)charSequence).append("invalid latitude: ");
                ((StringBuilder)charSequence).append(d);
                object = new IllegalArgumentException(((StringBuilder)charSequence).toString());
                throw object;
            }
            if (d2 > 180.0 || d2 < -180.0) {
                super();
                ((StringBuilder)charSequence).append("invalid longitude: ");
                ((StringBuilder)charSequence).append(d2);
                object = new IllegalArgumentException(((StringBuilder)charSequence).toString());
                throw object;
            }
            n4 = n & 7;
            if (n4 == 0) {
                super();
                ((StringBuilder)charSequence).append("No supported transition specified: ");
                ((StringBuilder)charSequence).append(n);
                object = new IllegalArgumentException(((StringBuilder)charSequence).toString());
                throw object;
            }
        } else {
            super();
            ((StringBuilder)charSequence).append("invalid radius: ");
            ((StringBuilder)charSequence).append(f);
            object = new IllegalArgumentException(((StringBuilder)charSequence).toString());
            throw object;
        }
        ((zzdh)object).zzc = s;
        ((zzdh)object).zza = charSequence;
        ((zzdh)object).zzd = d;
        ((zzdh)object).zze = d2;
        ((zzdh)object).zzf = f;
        ((zzdh)object).zzb = l;
        ((zzdh)object).zzg = n4;
        ((zzdh)object).zzh = n2;
        ((zzdh)object).zzi = n3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)2, (long)this.zzb);
        SafeParcelWriter.writeShort((Parcel)parcel, (int)3, (short)this.zzc);
        SafeParcelWriter.writeDouble((Parcel)parcel, (int)4, (double)this.zzd);
        SafeParcelWriter.writeDouble((Parcel)parcel, (int)5, (double)this.zze);
        SafeParcelWriter.writeFloat((Parcel)parcel, (int)6, (float)this.zzf);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)7, (int)this.zzg);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)8, (int)this.zzh);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)9, (int)this.zzi);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof zzdh) {
            object = (zzdh)object;
            return this.zzf == ((zzdh)object).zzf && this.zzd == ((zzdh)object).zzd && this.zze == ((zzdh)object).zze && this.zzc == ((zzdh)object).zzc;
        }
        return false;
    }
}

