/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.location.zzdh;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public double getLatitude();

    public double getLongitude();

    public float getRadius();

    public int getLoiteringDelay();

    public int getNotificationResponsiveness();

    @TransitionTypes
    public int getTransitionTypes();

    public long getExpirationTime();

    @NonNull
    public String getRequestId();

    public static final class Builder {
        private String zza = null;
        @TransitionTypes
        private int zzb = 0;
        private long zzc = Long.MIN_VALUE;
        private short zzd = (short)-1;
        private double zze;
        private double zzf;
        private float zzg;
        private int zzh = 0;
        private int zzi = -1;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setCircularRegion(@FloatRange(from=-90.0, to=90.0) double latitude, @FloatRange(from=-180.0, to=180.0) double longitude, @FloatRange(from=0.0, fromInclusive=false) float radius) {
            void var5_3;
            void var3_2;
            void var1_1;
            boolean bl = !(latitude < -90.0) ? var1_1 <= 90.0 : false;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid latitude: ");
            stringBuilder.append((double)var1_1);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            bl = !(var3_2 < -180.0) ? var3_2 <= 180.0 : false;
            stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid longitude: ");
            stringBuilder.append((double)var3_2);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            bl = var5_3 > 0.0f;
            stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid radius: ");
            stringBuilder.append((float)var5_3);
            Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
            this.zzd = 1;
            this.zze = var1_1;
            this.zzf = var3_2;
            this.zzg = var5_3;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public Builder setExpirationDuration(long durationMillis) {
            void var1_1;
            if (durationMillis < 0L) {
                this.zzc = -1L;
                return this;
            }
            this.zzc = DefaultClock.getInstance().elapsedRealtime() + var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setLoiteringDelay(int loiteringDelayMs) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setNotificationResponsiveness(@IntRange(from=0L) int notificationResponsivenessMs) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestId(@NonNull String requestId) {
            void var1_1;
            this.zza = (String)Preconditions.checkNotNull((Object)var1_1, (Object)"Request ID can't be set to null");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTransitionTypes(@TransitionTypes int transitionTypes) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public Geofence build() {
            Object this_;
            if (((Builder)this_).zza == null) {
                this_ = new IllegalArgumentException("Request ID not set.");
                throw this_;
            }
            int n = ((Builder)this_).zzb;
            if (n == 0) {
                this_ = new IllegalArgumentException("Transitions types not set.");
                throw this_;
            }
            if ((n & 4) == 0 || ((Builder)this_).zzi >= 0) {
                if (((Builder)this_).zzc == Long.MIN_VALUE) {
                    this_ = new IllegalArgumentException("Expiration not set.");
                    throw this_;
                }
                if (((Builder)this_).zzd == -1) {
                    this_ = new IllegalArgumentException("Geofence region not set.");
                    throw this_;
                }
                if (((Builder)this_).zzh < 0) {
                    this_ = new IllegalArgumentException("Notification responsiveness should be nonnegative.");
                    throw this_;
                }
            } else {
                this_ = new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELL.");
                throw this_;
            }
            zzdh zzdh2 = new zzdh(((Builder)this_).zza, ((Builder)this_).zzb, 1, ((Builder)this_).zze, ((Builder)this_).zzf, ((Builder)this_).zzg, ((Builder)this_).zzc, ((Builder)this_).zzh, ((Builder)this_).zzi);
            return zzdh2;
        }
    }

    public static @interface TransitionTypes {
    }

    public static @interface GeofenceTransition {
    }
}

