/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.location.zzdh;
import com.google.android.gms.location.Geofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zza;
    @Geofence.GeofenceTransition
    private final int zzb;
    @Nullable
    private final List zzc;
    @Nullable
    private final Location zzd;

    public int getErrorCode() {
        return this.zza;
    }

    @Geofence.GeofenceTransition
    public int getGeofenceTransition() {
        return this.zzb;
    }

    @Nullable
    public Location getTriggeringLocation() {
        return this.zzd;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static GeofencingEvent fromIntent(@NonNull Intent intent) {
        ArrayList<zzdh> arrayList;
        Object object;
        Intent intent2;
        if (intent == null) {
            return null;
        }
        int n = intent2.getIntExtra("gms_error_code", -1);
        int n2 = intent2.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n2 == -1) {
            n2 = -1;
        } else if (n2 != 1 && n2 != 2) {
            n2 = n2 == 4 ? 4 : -1;
        }
        if ((object = (ArrayList)intent2.getSerializableExtra("com.google.android.location.intent.extra.geofence_list")) == null) {
            arrayList = null;
        } else {
            ArrayList<zzdh> arrayList2 = new ArrayList<zzdh>(((ArrayList)object).size());
            int n3 = object.size();
            for (int i = 0; i < n3; ++i) {
                byte[] byArray = (byte[])object.get(i);
                Parcel parcel = Parcel.obtain();
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                Parcelable.Creator<zzdh> creator = zzdh.CREATOR;
                Object object2 = creator.createFromParcel(parcel);
                zzdh zzdh2 = (zzdh)object2;
                parcel.recycle();
                arrayList2.add(zzdh2);
            }
            arrayList = arrayList2;
        }
        intent2 = (Location)intent2.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        if (arrayList != null) return new GeofencingEvent(n, n2, arrayList, (Location)intent2);
        if (n != -1) return new GeofencingEvent(n, n2, arrayList, (Location)intent2);
        return null;
    }

    @Nullable
    public List<Geofence> getTriggeringGeofences() {
        return this.zzc;
    }

    private GeofencingEvent(int n, @Geofence.GeofenceTransition int n2, @Nullable List list, @Nullable Location location) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = list;
        this.zzd = location;
    }

    public boolean hasError() {
        return this.zza != -1;
    }
}

