/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import androidx.annotation.NonNull;
import com.google.android.gms.common.api.CommonStatusCodes;

public final class GeofenceStatusCodes
extends CommonStatusCodes {
    public static final int GEOFENCE_NOT_AVAILABLE = 1000;
    public static final int GEOFENCE_TOO_MANY_GEOFENCES = 1001;
    public static final int GEOFENCE_TOO_MANY_PENDING_INTENTS = 1002;
    public static final int GEOFENCE_INSUFFICIENT_LOCATION_PERMISSION = 1004;
    public static final int GEOFENCE_REQUEST_TOO_FREQUENT = 1005;

    @NonNull
    public static String getStatusCodeString(int statusCode) {
        switch (statusCode) {
            default: {
                int n;
                return CommonStatusCodes.getStatusCodeString((int)n);
            }
            case 1004: {
                return "GEOFENCE_INSUFFICIENT_LOCATION_PERMISSION";
            }
            case 1002: {
                return "GEOFENCE_TOO_MANY_PENDING_INTENTS";
            }
            case 1001: {
                return "GEOFENCE_TOO_MANY_GEOFENCES";
            }
            case 1000: 
        }
        return "GEOFENCE_NOT_AVAILABLE";
    }

    private GeofenceStatusCodes() {
    }

    public static int zza(int n) {
        if (n == 0 || n >= 1000 && n < 1006) {
            return n;
        }
        return 13;
    }
}

