/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import androidx.annotation.GuardedBy;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.RegistrationMethods;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzbf;
import com.google.android.gms.internal.location.zzbh;
import com.google.android.gms.internal.location.zzbj;
import com.google.android.gms.internal.location.zzbk;
import com.google.android.gms.internal.location.zzbl;
import com.google.android.gms.internal.location.zzbm;
import com.google.android.gms.internal.location.zzbn;
import com.google.android.gms.internal.location.zzbo;
import com.google.android.gms.internal.location.zzbp;
import com.google.android.gms.internal.location.zzbq;
import com.google.android.gms.internal.location.zzbr;
import com.google.android.gms.internal.location.zzbs;
import com.google.android.gms.internal.location.zzbt;
import com.google.android.gms.internal.location.zzbu;
import com.google.android.gms.internal.location.zzbv;
import com.google.android.gms.internal.location.zzbw;
import com.google.android.gms.internal.location.zzbx;
import com.google.android.gms.internal.location.zzby;
import com.google.android.gms.internal.location.zzbz;
import com.google.android.gms.internal.location.zzca;
import com.google.android.gms.internal.location.zzcb;
import com.google.android.gms.internal.location.zzcc;
import com.google.android.gms.internal.location.zzcd;
import com.google.android.gms.internal.location.zzce;
import com.google.android.gms.internal.location.zzcf;
import com.google.android.gms.internal.location.zzcg;
import com.google.android.gms.internal.location.zzch;
import com.google.android.gms.location.CurrentLocationRequest;
import com.google.android.gms.location.DeviceOrientationListener;
import com.google.android.gms.location.DeviceOrientationRequest;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LastLocationRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzo;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.Executor;

public final class zzbi
extends GoogleApi
implements FusedLocationProviderClient {
    static final Api.ClientKey zza = new Api.ClientKey();
    public static final Api zzb;
    private static final Object zzc;
    @GuardedBy(value="mockModeMarkerLock")
    private static Object zzd;

    public zzbi(Context context) {
        super(context, zzb, (Api.ApiOptions)Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zzbi(Activity activity) {
        super(activity, zzb, (Api.ApiOptions)Api.ApiOptions.NO_OPTIONS, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    protected final String getApiFallbackAttributionTag(Context context) {
        return null;
    }

    @Override
    public final Task<Location> getLastLocation() {
        return this.doRead(TaskApiCall.builder().run((RemoteCall)zzby.zza).setMethodKey(2414).build());
    }

    @Override
    public final Task<Location> getLastLocation(LastLocationRequest lastLocationRequest) {
        return this.doRead(TaskApiCall.builder().run((RemoteCall)new zzbj(lastLocationRequest)).setMethodKey(2414).setFeatures(new Feature[]{zzo.zzf}).build());
    }

    @Override
    public final Task<Location> getCurrentLocation(int n, CancellationToken cancellationToken) {
        CurrentLocationRequest.Builder builder = new CurrentLocationRequest.Builder();
        builder.setPriority(n);
        CurrentLocationRequest currentLocationRequest = builder.build();
        if (cancellationToken != null) {
            Preconditions.checkArgument((boolean)(cancellationToken.isCancellationRequested() ^ true), (Object)"cancellationToken may not be already canceled");
        }
        zzbi zzbi2 = zzbi2.doRead(TaskApiCall.builder().run((RemoteCall)new zzbp(currentLocationRequest, cancellationToken)).setMethodKey(2415).build());
        if (cancellationToken != null) {
            currentLocationRequest = new TaskCompletionSource(cancellationToken);
            zzbi2.continueWith(new zzbq((TaskCompletionSource)currentLocationRequest));
            return currentLocationRequest.getTask();
        }
        return zzbi2;
    }

    @Override
    public final Task<Location> getCurrentLocation(CurrentLocationRequest currentLocationRequest, CancellationToken cancellationToken) {
        if (cancellationToken != null) {
            Preconditions.checkArgument((boolean)(cancellationToken.isCancellationRequested() ^ true), (Object)"cancellationToken may not be already canceled");
        }
        zzbi zzbi2 = zzbi2.doRead(TaskApiCall.builder().run((RemoteCall)new zzbp(currentLocationRequest, cancellationToken)).setMethodKey(2415).build());
        if (cancellationToken != null) {
            currentLocationRequest = new TaskCompletionSource(cancellationToken);
            zzbi2.continueWith(new zzbq((TaskCompletionSource)currentLocationRequest));
            return currentLocationRequest.getTask();
        }
        return zzbi2;
    }

    @Override
    public final Task<LocationAvailability> getLocationAvailability() {
        return this.doRead(TaskApiCall.builder().run((RemoteCall)zzbr.zza).setMethodKey(2416).build());
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationListener locationListener, Looper looper) {
        if (looper == null) {
            Looper looper2 = Looper.myLooper();
            Preconditions.checkNotNull((Object)looper2, (Object)"invalid null looper");
            looper = looper2;
        }
        return this.zza(locationRequest, ListenerHolders.createListenerHolder((Object)locationListener, (Looper)looper, (String)LocationListener.class.getSimpleName()));
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, Executor executor, LocationListener locationListener) {
        return this.zza(locationRequest, ListenerHolders.createListenerHolder((Object)locationListener, (Executor)executor, (String)LocationListener.class.getSimpleName()));
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, LocationCallback locationCallback, Looper looper) {
        if (looper == null) {
            Looper looper2 = Looper.myLooper();
            Preconditions.checkNotNull((Object)looper2, (Object)"invalid null looper");
            looper = looper2;
        }
        return this.zzb(locationRequest, ListenerHolders.createListenerHolder((Object)locationCallback, (Looper)looper, (String)LocationCallback.class.getSimpleName()));
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, Executor executor, LocationCallback locationCallback) {
        return this.zzb(locationRequest, ListenerHolders.createListenerHolder((Object)locationCallback, (Executor)executor, (String)LocationCallback.class.getSimpleName()));
    }

    @Override
    public final Task<Void> requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzbs(pendingIntent, locationRequest)).setMethodKey(2417).build());
    }

    private final Task zza(LocationRequest locationRequest, ListenerHolder listenerHolder) {
        zzbh zzbh2 = new zzbh(this, listenerHolder, zzcd.zza);
        zzbt zzbt2 = new zzbt(zzbh2, locationRequest);
        return this.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzbt2).unregister((RemoteCall)zzbh2).withHolder(listenerHolder).setMethodKey(2435).build());
    }

    private final Task zzb(LocationRequest locationRequest, ListenerHolder listenerHolder) {
        zzbh zzbh2 = new zzbh(this, listenerHolder, zzbz.zza);
        zzbu zzbu2 = new zzbu(zzbh2, locationRequest);
        return this.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzbu2).unregister((RemoteCall)zzbh2).withHolder(listenerHolder).setMethodKey(2436).build());
    }

    @Override
    public final Task<Void> removeLocationUpdates(LocationListener locationListener) {
        return this.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)locationListener, (String)LocationListener.class.getSimpleName()), 2418).continueWith((Executor)zzch.zza, (Continuation)zzbv.zza);
    }

    @Override
    public final Task<Void> removeLocationUpdates(LocationCallback locationCallback) {
        return this.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)locationCallback, (String)LocationCallback.class.getSimpleName()), 2418).continueWith((Executor)zzce.zza, (Continuation)zzbw.zza);
    }

    @Override
    public final Task<Void> removeLocationUpdates(PendingIntent pendingIntent) {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzbx(pendingIntent)).setMethodKey(2418).build());
    }

    @Override
    public final Task<Void> flushLocations() {
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)zzca.zza).setMethodKey(2422).build());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final Task<Void> setMockMode(boolean bl) {
        zzbi zzbi2;
        Object object = zzc;
        // MONITORENTER : object
        if (bl) {
            Object object2 = zzd;
            if (object2 == null) {
                zzd = object2 = new Object();
                zzbi2 = zzbi2.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzcb.zza).unregister((RemoteCall)zzcc.zza).withHolder(ListenerHolders.createListenerHolder((Object)object2, (Looper)Looper.getMainLooper(), (String)Object.class.getSimpleName())).setMethodKey(2420).build());
                // MONITOREXIT : object
                return zzbi2;
            }
            // MONITOREXIT : object
            return Tasks.forResult(null);
        }
        Object object3 = zzd;
        if (object3 == null) return Tasks.forResult(null);
        zzd = null;
        zzbi2 = zzbi2.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)object3, (String)Object.class.getSimpleName()), 2420);
        zzbi2 = zzbi2.continueWith(zzcf.zza, zzbk.zza);
        // MONITOREXIT : object
        return zzbi2;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : object
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Task<Void> setMockLocation(Location location) {
        boolean bl = location != null;
        Preconditions.checkArgument((boolean)bl);
        return this.doWrite(TaskApiCall.builder().run((RemoteCall)new zzbl(location)).setMethodKey(2421).build());
    }

    @Override
    public final Task<Void> requestDeviceOrientationUpdates(DeviceOrientationRequest deviceOrientationRequest, Executor executor, DeviceOrientationListener deviceOrientationListener) {
        return this.zzc(deviceOrientationRequest, ListenerHolders.createListenerHolder((Object)deviceOrientationListener, (Executor)executor, (String)DeviceOrientationListener.class.getSimpleName()));
    }

    @Override
    public final Task<Void> requestDeviceOrientationUpdates(DeviceOrientationRequest deviceOrientationRequest, DeviceOrientationListener deviceOrientationListener, Looper looper) {
        if (looper == null) {
            Looper looper2 = Looper.myLooper();
            Preconditions.checkNotNull((Object)looper2, (Object)"invalid null looper");
            looper = looper2;
        }
        return this.zzc(deviceOrientationRequest, ListenerHolders.createListenerHolder((Object)deviceOrientationListener, (Looper)looper, (String)DeviceOrientationListener.class.getSimpleName()));
    }

    private final Task zzc(DeviceOrientationRequest object, ListenerHolder listenerHolder) {
        zzbm zzbm2 = new zzbm(listenerHolder, (DeviceOrientationRequest)((Object)object));
        object = new zzbn(listenerHolder);
        return this.doRegisterEventListener(RegistrationMethods.builder().register((RemoteCall)zzbm2).unregister((RemoteCall)object).withHolder(listenerHolder).setMethodKey(2434).build());
    }

    @Override
    public final Task<Void> removeDeviceOrientationUpdates(DeviceOrientationListener deviceOrientationListener) {
        return this.doUnregisterEventListener(ListenerHolders.createListenerKey((Object)deviceOrientationListener, (String)DeviceOrientationListener.class.getSimpleName()), 2440).continueWith((Executor)zzcg.zza, (Continuation)zzbo.zza);
    }

    static {
        zzbf zzbf2 = new zzbf();
        Api.ClientKey clientKey = zza;
        zzb = new Api("LocationServices.API", (Api.AbstractClientBuilder)zzbf2, clientKey);
        zzc = new Object();
    }
}

