/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzei;
import com.google.android.gms.internal.location.zzes;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="RemoveGeofencingRequestCreator")
public final class zzeh
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzeh> CREATOR = new zzei();
    @SafeParcelable.Field(id=1, getter="getGeofenceIds")
    private final List zza;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getPendingIntent")
    private final PendingIntent zzb;
    @SafeParcelable.Field(id=3, getter="getTag", defaultValue="")
    private final String zzc;

    public static zzeh zza(List list) {
        Preconditions.checkNotNull((Object)list, (Object)"geofence can't be null.");
        Preconditions.checkArgument((boolean)(list.isEmpty() ^ true), (Object)"Geofences must contains at least one id.");
        String string = "";
        return new zzeh(list, null, string);
    }

    public static zzeh zzb(PendingIntent pendingIntent) {
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent can not be null.");
        return new zzeh(null, pendingIntent, "");
    }

    public final void writeToParcel(Parcel parcel, int n) {
        List list = this.zza;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeStringList((Parcel)parcel, (int)1, (List)list, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.zzb, (int)n, (boolean)false);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    zzeh(@SafeParcelable.Param(id=1) @Nullable List list, @SafeParcelable.Param(id=2) @Nullable PendingIntent pendingIntent, @SafeParcelable.Param(id=3) String string) {
        list = list == null ? zzes.zzi() : zzes.zzj(list);
        this.zza = list;
        this.zzb = pendingIntent;
        this.zzc = string;
    }
}

