/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.WorkSourceUtil;
import com.google.android.gms.internal.location.zze;
import com.google.android.gms.internal.location.zzej;
import com.google.android.gms.location.zzan;
import com.google.android.gms.location.zzar;
import com.google.android.gms.location.zzj;
import com.google.android.gms.location.zzq;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Reserved(value={8})
@SafeParcelable.Class(creator="CurrentLocationRequestCreator")
public final class CurrentLocationRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<CurrentLocationRequest> CREATOR = new zzj();
    @SafeParcelable.Field(id=1, getter="getMaxUpdateAgeMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getGranularity", defaultValueUnchecked="Granularity.GRANULARITY_PERMISSION_LEVEL")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getPriority", defaultValueUnchecked="Priority.PRIORITY_BALANCED_POWER_ACCURACY")
    private final int zzc;
    @SafeParcelable.Field(id=4, getter="getDurationMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zzd;
    @SafeParcelable.Field(id=5, getter="isBypass", defaultValue="false")
    private final boolean zze;
    @SafeParcelable.Field(id=7, getter="getThrottleBehavior", defaultValueUnchecked="ThrottleBehavior.THROTTLE_BACKGROUND")
    private final int zzf;
    @SafeParcelable.Field(id=6, getter="getWorkSource", defaultValueUnchecked="new android.os.WorkSource()")
    private final WorkSource zzg;
    @SafeParcelable.Field(id=9, getter="getImpersonation")
    @Nullable
    private final zze zzh;

    @Pure
    public long getMaxUpdateAgeMillis() {
        return this.zza;
    }

    @Pure
    public int getGranularity() {
        return this.zzb;
    }

    @Pure
    public int getPriority() {
        return this.zzc;
    }

    @Pure
    public long getDurationMillis() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)1, (long)this.getMaxUpdateAgeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getGranularity());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getPriority());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)4, (long)this.getDurationMillis());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.zze);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)6, (Parcelable)this.zzg, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)7, (int)this.zzf);
        void v1 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v1, (int)9, (Parcelable)this.zzh, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CurrentLocationRequest[");
        stringBuilder.append(zzan.zzb(this.zzc));
        if (this.zza != Long.MAX_VALUE) {
            stringBuilder.append(", maxAge=");
            zzej.zzc(this.zza, stringBuilder);
        }
        if (this.zzd != Long.MAX_VALUE) {
            stringBuilder.append(", duration=");
            stringBuilder.append(this.zzd);
            stringBuilder.append("ms");
        }
        if (this.zzb != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzq.zzb(this.zzb));
        }
        if (this.zze) {
            stringBuilder.append(", bypass");
        }
        if (this.zzf != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzar.zzb(this.zzf));
        }
        if (!WorkSourceUtil.isEmpty((WorkSource)this.zzg)) {
            stringBuilder.append(", workSource=");
            stringBuilder.append(this.zzg);
        }
        if (this.zzh != null) {
            stringBuilder.append(", impersonation=");
            stringBuilder.append((Object)this.zzh);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.zzd});
    }

    public boolean equals(@Nullable Object object) {
        CurrentLocationRequest currentLocationRequest;
        if (!(object instanceof CurrentLocationRequest)) {
            return false;
        }
        currentLocationRequest = currentLocationRequest;
        return this.zza == currentLocationRequest.zza && this.zzb == currentLocationRequest.zzb && this.zzc == currentLocationRequest.zzc && this.zzd == currentLocationRequest.zzd && this.zze == currentLocationRequest.zze && this.zzf == currentLocationRequest.zzf && Objects.equal((Object)this.zzg, (Object)currentLocationRequest.zzg) && Objects.equal((Object)((Object)this.zzh), (Object)((Object)currentLocationRequest.zzh));
    }

    @SafeParcelable.Constructor
    CurrentLocationRequest(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) int n2, @SafeParcelable.Param(id=4) long l2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=7) int n3, @SafeParcelable.Param(id=6) WorkSource workSource, @SafeParcelable.Param(id=9) @Nullable zze zze2) {
        this.zza = l;
        this.zzb = n;
        this.zzc = n2;
        this.zzd = l2;
        this.zze = bl;
        this.zzf = n3;
        this.zzg = workSource;
        this.zzh = zze2;
    }

    @Pure
    public final boolean zza() {
        return this.zze;
    }

    @Pure
    public final int zzb() {
        return this.zzf;
    }

    @Pure
    @NonNull
    public final WorkSource zzc() {
        return this.zzg;
    }

    @Pure
    @Nullable
    public final zze zzd() {
        return this.zzh;
    }

    public static final class Builder {
        private long zza;
        private int zzb;
        private int zzc;
        private long zzd;
        private final boolean zze;
        private final int zzf;
        @Nullable
        private final WorkSource zzg;
        @Nullable
        private final zze zzh;

        public Builder() {
            this.zza = 10000L;
            this.zzb = 0;
            this.zzc = 102;
            this.zzd = Long.MAX_VALUE;
            this.zze = false;
            this.zzf = 0;
            this.zzg = null;
            this.zzh = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull CurrentLocationRequest request) {
            void var1_1;
            this.zza = var1_1.getMaxUpdateAgeMillis();
            this.zzb = var1_1.getGranularity();
            this.zzc = var1_1.getPriority();
            this.zzd = var1_1.getDurationMillis();
            this.zze = var1_1.zza();
            this.zzf = var1_1.zzb();
            this.zzg = new WorkSource(var1_1.zzc());
            this.zzh = var1_1.zzd();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateAgeMillis(long maxUpdateAgeMillis) {
            void var1_1;
            boolean bl = maxUpdateAgeMillis >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateAgeMillis must be greater than or equal to 0");
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGranularity(int granularity) {
            void var1_1;
            zzq.zza(granularity);
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPriority(int priority) {
            void var1_1;
            zzan.zza(priority);
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setDurationMillis(long durationMillis) {
            void var1_1;
            boolean bl = durationMillis > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"durationMillis must be greater than 0");
            this.zzd = var1_1;
            return this;
        }

        @NonNull
        public CurrentLocationRequest build() {
            WorkSource workSource = new WorkSource(this.zzg);
            return new CurrentLocationRequest(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, workSource, this.zzh);
        }
    }
}

