/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zze;
import com.google.android.gms.internal.location.zzej;
import com.google.android.gms.location.zzaa;
import com.google.android.gms.location.zzq;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Reserved(value={4})
@SafeParcelable.Class(creator="LastLocationRequestCreator")
public final class LastLocationRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<LastLocationRequest> CREATOR = new zzaa();
    @SafeParcelable.Field(id=1, getter="getMaxUpdateAgeMillis", defaultValueUnchecked="Long.MAX_VALUE")
    private final long zza;
    @SafeParcelable.Field(id=2, getter="getGranularity", defaultValueUnchecked="com.google.android.gms.location.Granularity.GRANULARITY_PERMISSION_LEVEL")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="isBypass", defaultValue="false")
    private final boolean zzc;
    @SafeParcelable.Field(id=5, getter="getImpersonation")
    @Nullable
    private final zze zzd;

    @Pure
    public long getMaxUpdateAgeMillis() {
        return this.zza;
    }

    @Pure
    public int getGranularity() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)1, (long)this.getMaxUpdateAgeMillis());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getGranularity());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.zzc);
        void v1 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v1, (int)5, (Parcelable)this.zzd, (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LastLocationRequest[");
        if (this.zza != Long.MAX_VALUE) {
            stringBuilder.append("maxAge=");
            zzej.zzc(this.zza, stringBuilder);
        }
        if (this.zzb != 0) {
            stringBuilder.append(", ");
            stringBuilder.append(zzq.zzb(this.zzb));
        }
        if (this.zzc) {
            stringBuilder.append(", bypass");
        }
        if (this.zzd != null) {
            stringBuilder.append(", impersonation=");
            stringBuilder.append((Object)this.zzd);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc});
    }

    public boolean equals(@Nullable Object object) {
        LastLocationRequest lastLocationRequest;
        if (!(object instanceof LastLocationRequest)) {
            return false;
        }
        lastLocationRequest = lastLocationRequest;
        return this.zza == lastLocationRequest.zza && this.zzb == lastLocationRequest.zzb && this.zzc == lastLocationRequest.zzc && Objects.equal((Object)((Object)this.zzd), (Object)((Object)lastLocationRequest.zzd));
    }

    @SafeParcelable.Constructor
    LastLocationRequest(@SafeParcelable.Param(id=1) long l, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) boolean bl, @SafeParcelable.Param(id=5) @Nullable zze zze2) {
        this.zza = l;
        this.zzb = n;
        this.zzc = bl;
        this.zzd = zze2;
    }

    @Pure
    public final boolean zza() {
        return this.zzc;
    }

    @Pure
    @Nullable
    public final zze zzb() {
        return this.zzd;
    }

    public static final class Builder {
        private long zza;
        private int zzb;
        private final boolean zzc;
        @Nullable
        private final zze zzd;

        public Builder() {
            this.zza = Long.MAX_VALUE;
            this.zzb = 0;
            this.zzc = false;
            this.zzd = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull LastLocationRequest request) {
            void var1_1;
            this.zza = var1_1.getMaxUpdateAgeMillis();
            this.zzb = var1_1.getGranularity();
            this.zzc = var1_1.zza();
            this.zzd = var1_1.zzb();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setMaxUpdateAgeMillis(long maxUpdateAgeMillis) {
            void var1_1;
            boolean bl = maxUpdateAgeMillis > 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"maxUpdateAgeMillis must be greater than 0");
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGranularity(int granularity) {
            void var1_1;
            zzq.zza(granularity);
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public LastLocationRequest build() {
            return new LastLocationRequest(this.zza, this.zzb, this.zzc, this.zzd);
        }
    }
}

