/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.location.zzer;
import com.google.android.gms.location.zzm;
import java.util.Arrays;
import org.checkerframework.dataflow.qual.Pure;

@SafeParcelable.Reserved(value={2, 3})
@SafeParcelable.Class(creator="DeviceOrientationCreator")
public class DeviceOrientation
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<DeviceOrientation> CREATOR = new zzm();
    @SafeParcelable.Field(id=1, getter="getAttitude")
    private final float[] zza;
    @SafeParcelable.Field(id=4, getter="getHeadingDegrees")
    private final float zzb;
    @SafeParcelable.Field(id=5, getter="getHeadingErrorDegrees")
    private final float zzc;
    @SafeParcelable.Field(id=6, getter="getElapsedRealtimeNs")
    private final long zzd;
    @SafeParcelable.Field(id=7, getter="getFieldMask")
    private final byte zze;
    @SafeParcelable.Field(id=8, getter="getConservativeHeadingErrorVonMisesKappa")
    private final float zzf;
    @SafeParcelable.Field(id=9, getter="getConservativeHeadingErrorDegrees")
    private final float zzg;

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    DeviceOrientation(@SafeParcelable.Param(id=1) float[] fArray, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) float f2, @SafeParcelable.Param(id=6) long l, @SafeParcelable.Param(id=7) byte by, @SafeParcelable.Param(id=8) float f3, @SafeParcelable.Param(id=9) float f4) {
        DeviceOrientation.zzj(fArray);
        boolean bl = f >= 0.0f ? f < 360.0f : false;
        zzer.zza(bl);
        bl = f2 >= 0.0f ? f2 <= 180.0f : false;
        zzer.zza(bl);
        bl = f4 >= 0.0f ? f4 <= 180.0f : false;
        zzer.zza(bl);
        bl = l >= 0L;
        zzer.zza(bl);
        this.zza = fArray;
        this.zzb = f;
        this.zzc = f2;
        this.zzf = f3;
        this.zzg = f4;
        this.zzd = l;
        this.zze = (byte)((byte)((byte)(by | 0x10) | 4) | 8);
    }

    @Pure
    public float getHeadingDegrees() {
        return this.zzb;
    }

    @Pure
    public float getHeadingErrorDegrees() {
        return this.zzc;
    }

    @Pure
    public float getConservativeHeadingErrorDegrees() {
        return this.zzg;
    }

    @Pure
    public boolean hasConservativeHeadingErrorDegrees() {
        return (this.zze & 0x40) != 0;
    }

    @Pure
    public long getElapsedRealtimeNs() {
        return this.zzd;
    }

    @Pure
    @NonNull
    public float[] getAttitude() {
        return (float[])this.zza.clone();
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeFloatArray((Parcel)var1_1, (int)1, (float[])this.getAttitude(), (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)4, (float)this.getHeadingDegrees());
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)5, (float)this.getHeadingErrorDegrees());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)6, (long)this.getElapsedRealtimeNs());
        SafeParcelWriter.writeByte((Parcel)var1_1, (int)7, (byte)this.zze);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)8, (float)this.zzf);
        void v1 = var1_1;
        SafeParcelWriter.writeFloat((Parcel)v1, (int)9, (float)this.getConservativeHeadingErrorDegrees());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    @Pure
    @NonNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DeviceOrientation[");
        stringBuilder.append("attitude=");
        stringBuilder.append(Arrays.toString(this.zza));
        stringBuilder.append(", headingDegrees=");
        stringBuilder.append(this.zzb);
        stringBuilder.append(", headingErrorDegrees=");
        stringBuilder.append(this.zzc);
        if (this.hasConservativeHeadingErrorDegrees()) {
            stringBuilder.append(", conservativeHeadingErrorDegrees=");
            stringBuilder.append(this.zzg);
        }
        stringBuilder.append(", elapsedRealtimeNs=");
        stringBuilder.append(this.zzd);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Pure
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.zzb), Float.valueOf(this.zzc), Float.valueOf(this.zzg), this.zzd, this.zza, this.zze});
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Pure
    public boolean equals(@Nullable Object object) {
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof DeviceOrientation)) {
            return false;
        }
        DeviceOrientation deviceOrientation = (DeviceOrientation)var1_1;
        boolean bl = this.zza() == deviceOrientation.zza() ? (this.zza() ? Float.compare(this.zzf, deviceOrientation.zzf) == 0 : true) : false;
        boolean bl2 = this.hasConservativeHeadingErrorDegrees() == deviceOrientation.hasConservativeHeadingErrorDegrees() ? (this.hasConservativeHeadingErrorDegrees() ? Float.compare(this.getConservativeHeadingErrorDegrees(), deviceOrientation.getConservativeHeadingErrorDegrees()) == 0 : true) : false;
        return Float.compare(this.zzb, deviceOrientation.zzb) == 0 && Float.compare(this.zzc, deviceOrientation.zzc) == 0 && bl && bl2 && this.zzd == deviceOrientation.zzd && Arrays.equals(this.zza, deviceOrientation.zza);
    }

    @Pure
    public final boolean zza() {
        return (this.zze & 0x20) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void zzj(float[] fArray) {
        boolean bl = fArray != null ? fArray.length == 4 : false;
        zzer.zzb(bl, "Input attitude array should be of length 4.");
        boolean bl2 = !Float.isNaN(fArray[0]) ? (!Float.isNaN(fArray[1]) ? (!Float.isNaN(fArray[2]) ? !Float.isNaN(fArray[3]) : false) : false) : false;
        zzer.zzb(bl2, "Input attitude cannot contain NaNs.");
    }

    final /* synthetic */ float[] zzc() {
        return this.zza;
    }

    final /* synthetic */ float zzd() {
        return this.zzb;
    }

    final /* synthetic */ float zze() {
        return this.zzc;
    }

    final /* synthetic */ long zzf() {
        return this.zzd;
    }

    final /* synthetic */ byte zzg() {
        return this.zze;
    }

    final /* synthetic */ float zzh() {
        return this.zzf;
    }

    final /* synthetic */ float zzi() {
        return this.zzg;
    }

    public static final class Builder {
        private final float[] zza;
        private float zzb;
        private float zzc;
        private long zzd;
        private byte zze = 0;
        private float zzf;
        private float zzg;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull float[] attitude, float headingDegrees, float headingErrorDegrees, long elapsedRealtimeNs) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            DeviceOrientation.zzj((float[])var1_1);
            void v0 = var1_1;
            this.zza = Arrays.copyOf((float[])v0, ((void)v0).length);
            this.setHeadingDegrees((float)var2_2);
            this.setHeadingErrorDegrees((float)var3_3);
            this.setElapsedRealtimeNs((long)var4_4);
            this.zzf = 0.0f;
            this.zzg = 180.0f;
            this.zze = 0;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull DeviceOrientation src) {
            void var1_1;
            DeviceOrientation.zzj(var1_1.zzc());
            this.zza = Arrays.copyOf(var1_1.zzc(), var1_1.zzc().length);
            this.setHeadingDegrees(var1_1.zzd());
            this.setHeadingErrorDegrees(var1_1.zze());
            this.setConservativeHeadingErrorDegrees(var1_1.zzi());
            this.setElapsedRealtimeNs(var1_1.zzf());
            this.zzf = var1_1.zzh();
            this.zze = var1_1.zzg();
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAttitude(@NonNull float[] attitude) {
            void var1_1;
            DeviceOrientation.zzj(attitude);
            int n = ((void)var1_1).length;
            System.arraycopy(var1_1, 0, this.zza, 0, n);
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setHeadingDegrees(float headingDegrees) {
            void var1_1;
            boolean bl = headingDegrees >= 0.0f ? var1_1 < 360.0f : false;
            zzer.zzb(bl, "headingDegrees should be greater than or equal to 0 and less than 360.");
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setHeadingErrorDegrees(float headingErrorDegrees) {
            void var1_1;
            boolean bl = headingErrorDegrees >= 0.0f ? var1_1 <= 180.0f : false;
            zzer.zzb(bl, "headingErrorDegrees should be between 0 and 180.");
            this.zzc = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setConservativeHeadingErrorDegrees(float conservativeHeadingErrorDegrees) {
            float f;
            boolean bl = conservativeHeadingErrorDegrees >= 0.0f ? f <= 180.0f : false;
            zzer.zzb(bl, "conservativeHeadingErrorDegrees should be between 0 and 180.");
            this.zzg = f;
            this.zze = (byte)(this.zze | 0x40);
            f = f >= 180.0f ? 0.0f : (float)(2.0 / (1.0 - Math.cos(Math.toRadians(f))));
            this.zzf = f;
            this.zze = (byte)(this.zze | 0x20);
            return this;
        }

        @NonNull
        public Builder clearConservativeHeadingErrorDegrees() {
            this.zzg = 180.0f;
            Builder builder = this;
            builder.zzf = 0.0f;
            builder.zze = (byte)((byte)(this.zze & 0xFFFFFFBF) & 0xFFFFFFDF);
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setElapsedRealtimeNs(long elapsedRealtimeNs) {
            void var1_1;
            boolean bl = elapsedRealtimeNs >= 0L;
            zzer.zzb(bl, "elapsedRealtimeNs should be greater than or equal to 0.");
            this.zzd = var1_1;
            return this;
        }

        @NonNull
        public DeviceOrientation build() {
            return new DeviceOrientation(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg);
        }
    }
}

