/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.location;

import android.app.PendingIntent;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.location.zzaq;
import com.google.android.gms.internal.location.zzar;
import com.google.android.gms.internal.location.zzas;
import com.google.android.gms.internal.location.zzat;
import com.google.android.gms.internal.location.zzau;
import com.google.android.gms.internal.location.zzav;
import com.google.android.gms.internal.location.zzaw;
import com.google.android.gms.internal.location.zzax;
import com.google.android.gms.internal.location.zzay;
import com.google.android.gms.internal.location.zzbc;
import com.google.android.gms.internal.location.zzbd;
import com.google.android.gms.internal.location.zzbe;
import com.google.android.gms.internal.location.zzbi;
import com.google.android.gms.internal.location.zzdz;
import com.google.android.gms.internal.location.zzfd;
import com.google.android.gms.location.FusedLocationProviderApi;
import com.google.android.gms.location.LastLocationRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzac;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class zzbb
implements FusedLocationProviderApi {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final Location getLastLocation(GoogleApiClient object) {
        boolean bl = object != null;
        Preconditions.checkArgument((boolean)bl, (Object)"GoogleApiClient parameter is required.");
        zzdz zzdz2 = (zzdz)object.getClient((Api.AnyClientKey)zzbi.zza);
        object = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        try {
            zzdz2.zzq(new LastLocationRequest.Builder().build(), taskCompletionSource);
        }
        catch (Exception exception) {
            return null;
        }
        taskCompletionSource.getTask().addOnCompleteListener((OnCompleteListener)new zzbe((AtomicReference)object, countDownLatch));
        if (!zzfd.zza(countDownLatch, 30L, TimeUnit.SECONDS)) return null;
        return (Location)((AtomicReference)object).get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final LocationAvailability getLocationAvailability(GoogleApiClient object) {
        boolean bl = object != null;
        Preconditions.checkArgument((boolean)bl, (Object)"GoogleApiClient parameter is required.");
        zzdz zzdz2 = (zzdz)object.getClient((Api.AnyClientKey)zzbi.zza);
        object = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        try {
            zzdz2.zzp(zzac.zza(), taskCompletionSource);
        }
        catch (RemoteException remoteException) {
            return null;
        }
        taskCompletionSource.getTask().addOnCompleteListener((OnCompleteListener)new zzbc((AtomicReference)object, countDownLatch));
        if (!zzfd.zza(countDownLatch, 30L, TimeUnit.SECONDS)) return null;
        return (LocationAvailability)((Object)((AtomicReference)object).get());
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationListener locationListener) {
        Looper looper = Looper.myLooper();
        Preconditions.checkNotNull((Object)looper, (Object)"invalid null looper");
        locationListener = ListenerHolders.createListenerHolder((Object)locationListener, (Looper)looper, (String)LocationListener.class.getSimpleName());
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzar(this, googleApiClient, (ListenerHolder)locationListener, locationRequest));
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationListener locationListener, Looper looper) {
        if (looper == null) {
            Looper looper2 = Looper.myLooper();
            Preconditions.checkNotNull((Object)looper2, (Object)"invalid null looper");
            looper = looper2;
        }
        locationListener = ListenerHolders.createListenerHolder((Object)locationListener, (Looper)looper, (String)LocationListener.class.getSimpleName());
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzar(this, googleApiClient, (ListenerHolder)locationListener, locationRequest));
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, LocationCallback locationCallback, Looper looper) {
        if (looper == null) {
            Looper looper2 = Looper.myLooper();
            Preconditions.checkNotNull((Object)looper2, (Object)"invalid null looper");
            looper = looper2;
        }
        locationCallback = ListenerHolders.createListenerHolder((Object)locationCallback, (Looper)looper, (String)LocationCallback.class.getSimpleName());
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzas(this, googleApiClient, (ListenerHolder)locationCallback, locationRequest));
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final PendingResult<Status> requestLocationUpdates(GoogleApiClient googleApiClient, LocationRequest locationRequest, PendingIntent pendingIntent) {
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzat(this, googleApiClient, pendingIntent, locationRequest));
    }

    @Override
    public final PendingResult<Status> removeLocationUpdates(GoogleApiClient googleApiClient, LocationListener locationListener) {
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzau(this, googleApiClient, locationListener));
    }

    @Override
    public final PendingResult<Status> removeLocationUpdates(GoogleApiClient googleApiClient, PendingIntent pendingIntent) {
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzav(this, googleApiClient, pendingIntent));
    }

    @Override
    public final PendingResult<Status> removeLocationUpdates(GoogleApiClient googleApiClient, LocationCallback locationCallback) {
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzaw(this, googleApiClient, locationCallback));
    }

    @Override
    public final PendingResult<Status> setMockMode(GoogleApiClient googleApiClient, boolean bl) {
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzax(this, googleApiClient, bl));
    }

    @Override
    public final PendingResult<Status> setMockLocation(GoogleApiClient googleApiClient, Location location) {
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzay(this, googleApiClient, location));
    }

    @Override
    public final PendingResult<Status> flushLocations(GoogleApiClient googleApiClient) {
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzaq(this, googleApiClient));
    }

    static /* synthetic */ TaskCompletionSource zza(BaseImplementation.ResultHolder resultHolder) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        taskCompletionSource.getTask().addOnCompleteListener((OnCompleteListener)new zzbd(resultHolder));
        return taskCompletionSource;
    }
}

