/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.LocationRequestUpdateData;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzn;
import com.google.android.gms.location.zzc;
import com.google.android.gms.location.zzd;
import java.util.HashMap;
import java.util.Map;

public class zzi {
    private final zzn<zzg> zzaqz;
    private final Context mContext;
    private ContentProviderClient zzaqU = null;
    private boolean zzaqV = false;
    private Map<LocationListener, zzc> zzadz = new HashMap<LocationListener, zzc>();
    private Map<LocationCallback, zza> zzaqW = new HashMap<LocationCallback, zza>();

    public zzi(Context context, zzn<zzg> zzn2) {
        this.mContext = context;
        this.zzaqz = zzn2;
    }

    public Location getLastLocation() {
        this.zzaqz.zzlW();
        try {
            return this.zzaqz.zzlX().zzcF(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public LocationAvailability zzsI() {
        this.zzaqz.zzlW();
        try {
            return this.zzaqz.zzlX().zzcG(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper) throws RemoteException {
        this.zzaqz.zzlW();
        zzc zzc2 = this.zza(locationListener, looper);
        this.zzaqz.zzlX().zza(LocationRequestUpdateData.zzb(LocationRequestInternal.zzb(locationRequest), zzc2));
    }

    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper) throws RemoteException {
        this.zzaqz.zzlW();
        zza zza2 = this.zza(locationCallback, looper);
        this.zzaqz.zzlX().zza(LocationRequestUpdateData.zza(locationRequestInternal, zza2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zza(LocationListener locationListener, Looper looper) {
        Map<LocationListener, zzc> map = this.zzadz;
        synchronized (map) {
            zzc zzc2 = this.zzadz.get(locationListener);
            if (zzc2 == null) {
                zzc2 = new zzc(locationListener, looper);
            }
            this.zzadz.put(locationListener, zzc2);
            return zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zza zza(LocationCallback locationCallback, Looper looper) {
        Map<LocationListener, zzc> map = this.zzadz;
        synchronized (map) {
            zza zza2 = this.zzaqW.get(locationCallback);
            if (zza2 == null) {
                zza2 = new zza(locationCallback, looper);
            }
            this.zzaqW.put(locationCallback, zza2);
            return zza2;
        }
    }

    public void zzb(LocationRequest locationRequest, PendingIntent pendingIntent) throws RemoteException {
        this.zzaqz.zzlW();
        this.zzaqz.zzlX().zza(LocationRequestUpdateData.zzb(LocationRequestInternal.zzb(locationRequest), pendingIntent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationListener locationListener) throws RemoteException {
        this.zzaqz.zzlW();
        zzv.zzb((Object)locationListener, (Object)"Invalid null listener");
        Map<LocationListener, zzc> map = this.zzadz;
        synchronized (map) {
            zzc zzc2 = this.zzadz.remove(locationListener);
            if (this.zzaqU != null && this.zzadz.isEmpty()) {
                this.zzaqU.release();
                this.zzaqU = null;
            }
            if (zzc2 != null) {
                zzc2.release();
                this.zzaqz.zzlX().zza(LocationRequestUpdateData.zzb(zzc2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationCallback locationCallback) throws RemoteException {
        this.zzaqz.zzlW();
        zzv.zzb((Object)locationCallback, (Object)"Invalid null callback");
        Map<LocationCallback, zza> map = this.zzaqW;
        synchronized (map) {
            zza zza2 = this.zzaqW.remove(locationCallback);
            if (zza2 != null) {
                zza2.release();
                this.zzaqz.zzlX().zza(LocationRequestUpdateData.zza(zza2));
            }
        }
    }

    public void zzd(PendingIntent pendingIntent) throws RemoteException {
        this.zzaqz.zzlW();
        this.zzaqz.zzlX().zza(LocationRequestUpdateData.zze(pendingIntent));
    }

    public void zzX(boolean bl) throws RemoteException {
        this.zzaqz.zzlW();
        this.zzaqz.zzlX().zzX(bl);
        this.zzaqV = bl;
    }

    public void zzb(Location location) throws RemoteException {
        this.zzaqz.zzlW();
        this.zzaqz.zzlX().zzb(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            Map<LocationListener, zzc> map = this.zzadz;
            synchronized (map) {
                for (zzc binder : this.zzadz.values()) {
                    if (binder == null) continue;
                    this.zzaqz.zzlX().zza(LocationRequestUpdateData.zzb(binder));
                }
                this.zzadz.clear();
                for (zza zza2 : this.zzaqW.values()) {
                    if (zza2 == null) continue;
                    this.zzaqz.zzlX().zza(LocationRequestUpdateData.zza(zza2));
                }
                this.zzaqW.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzsJ() {
        if (this.zzaqV) {
            try {
                this.zzX(false);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    private static class zzb
    extends Handler {
        private final LocationListener zzaqZ;

        public zzb(LocationListener locationListener) {
            this.zzaqZ = locationListener;
        }

        public zzb(LocationListener locationListener, Looper looper) {
            super(looper);
            this.zzaqZ = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.zzaqZ.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class zza
    extends zzc.zza {
        private Handler zzaqX;

        zza(final LocationCallback locationCallback, Looper looper) {
            if (looper == null) {
                looper = Looper.myLooper();
                zzv.zza((looper != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaqX = new Handler(looper){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            locationCallback.onLocationResult((LocationResult)msg.obj);
                            break;
                        }
                        case 1: {
                            locationCallback.onLocationAvailability((LocationAvailability)msg.obj);
                        }
                    }
                }
            };
        }

        @Override
        public void onLocationResult(LocationResult locationResult) {
            this.zzb(0, locationResult);
        }

        @Override
        public void onLocationAvailability(LocationAvailability state) {
            this.zzb(1, state);
        }

        public void release() {
            this.zzaqX = null;
        }

        private void zzb(int n, Object object) {
            if (this.zzaqX == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a data in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = n;
            message.obj = object;
            this.zzaqX.sendMessage(message);
        }
    }

    private static class zzc
    extends zzd.zza {
        private Handler zzaqX;

        zzc(LocationListener locationListener, Looper looper) {
            if (looper == null) {
                zzv.zza((Looper.myLooper() != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaqX = looper == null ? new zzb(locationListener) : new zzb(locationListener, looper);
        }

        @Override
        public void onLocationChanged(Location location) {
            if (this.zzaqX == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.zzaqX.sendMessage(message);
        }

        public void release() {
            this.zzaqX = null;
        }
    }
}

