/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int mVersionCode;
    int mPriority;
    long zzaBW;
    long zzaBX;
    boolean zzaqs;
    long zzaBB;
    int zzaBY;
    float zzaBZ;
    long zzaCa;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mVersionCode = 1;
        this.mPriority = 102;
        this.zzaBW = 3600000L;
        this.zzaBX = 600000L;
        this.zzaqs = false;
        this.zzaBB = Long.MAX_VALUE;
        this.zzaBY = Integer.MAX_VALUE;
        this.zzaBZ = 0.0f;
        this.zzaCa = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.zzgG(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.zzK(millis);
        this.zzaBW = millis;
        if (!this.zzaqs) {
            this.zzaBX = (long)((double)this.zzaBW / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzaBW;
    }

    public LocationRequest setMaxWaitTime(long millis) {
        LocationRequest.zzK(millis);
        this.zzaCa = millis;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzaCa;
        if (l < this.zzaBW) {
            l = this.zzaBW;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.zzK(millis);
        this.zzaqs = true;
        this.zzaBX = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.zzaBX;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l = SystemClock.elapsedRealtime();
        this.zzaBB = millis > Long.MAX_VALUE - l ? Long.MAX_VALUE : millis + l;
        if (this.zzaBB < 0L) {
            this.zzaBB = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.zzaBB = millis;
        if (this.zzaBB < 0L) {
            this.zzaBB = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzaBB;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.zzaBY = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.zzaBY;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.zzd(smallestDisplacementMeters);
        this.zzaBZ = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzaBZ;
    }

    private static void zzK(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l);
        }
    }

    private static void zzgG(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n);
            }
        }
    }

    private static void zzd(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.mVersionCode = versionCode;
        this.mPriority = priority;
        this.zzaBW = interval;
        this.zzaBX = fastestInterval;
        this.zzaqs = explicitFastestInterval;
        this.zzaBB = expireAt;
        this.zzaBY = numUpdates;
        this.zzaBZ = smallestDisplacement;
        this.zzaCa = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.zza(this, parcel, flags);
    }

    public static String zzgH(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzgH(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzaBW + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzaBX + "ms");
        if (this.zzaCa > this.zzaBW) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzaCa + "ms");
        }
        if (this.zzaBB != Long.MAX_VALUE) {
            long l = this.zzaBB - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l + "ms");
        }
        if (this.zzaBY != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzaBY);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mPriority, this.zzaBW, this.zzaBX, this.zzaqs, this.zzaBB, this.zzaBY, Float.valueOf(this.zzaBZ)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.zzaBW == locationRequest.zzaBW && this.zzaBX == locationRequest.zzaBX && this.zzaqs == locationRequest.zzaqs && this.zzaBB == locationRequest.zzaBB && this.zzaBY == locationRequest.zzaBY && this.zzaBZ == locationRequest.zzaBZ;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }
}

