/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class LocationSettingsRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<LocationRequest> zzasK;
    private final boolean zzaEL;
    private final boolean zzaEM;
    private final boolean zzaEN;
    public static final Parcelable.Creator<LocationSettingsRequest> CREATOR = new zzf();

    LocationSettingsRequest(int version, List<LocationRequest> locationRequests, boolean alwaysShow, boolean needBle, boolean optInUserLocationReporting) {
        this.mVersionCode = version;
        this.zzasK = locationRequests;
        this.zzaEL = alwaysShow;
        this.zzaEM = needBle;
        this.zzaEN = optInUserLocationReporting;
    }

    private LocationSettingsRequest(List<LocationRequest> locationRequests, boolean alwaysShow, boolean needBle, boolean optInUserLocationReporting) {
        this(2, locationRequests, alwaysShow, needBle, optInUserLocationReporting);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public List<LocationRequest> zztd() {
        return Collections.unmodifiableList(this.zzasK);
    }

    public boolean zzwx() {
        return this.zzaEL;
    }

    public boolean zzwy() {
        return this.zzaEM;
    }

    public boolean zzwz() {
        return this.zzaEN;
    }

    public static final class Builder {
        private final ArrayList<LocationRequest> zzaEO = new ArrayList();
        private boolean zzaEL = false;
        private boolean zzaEM = false;
        private boolean zzaEN = false;

        public Builder addLocationRequest(LocationRequest request) {
            this.zzaEO.add(request);
            return this;
        }

        public Builder addAllLocationRequests(Collection<LocationRequest> requests) {
            this.zzaEO.addAll(requests);
            return this;
        }

        public Builder setAlwaysShow(boolean show) {
            this.zzaEL = show;
            return this;
        }

        public Builder setNeedBle(boolean needBle) {
            this.zzaEM = needBle;
            return this;
        }

        public LocationSettingsRequest build() {
            return new LocationSettingsRequest(this.zzaEO, this.zzaEL, this.zzaEM, this.zzaEN);
        }
    }
}

