/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.zzo;
import java.util.Locale;

public class ParcelableGeofence
implements SafeParcelable,
Geofence {
    private final int mVersionCode;
    private final String zzBY;
    private final long zzaFO;
    private final short zzaEk;
    private final double zzaEl;
    private final double zzaEm;
    private final float zzaEn;
    private final int zzaEi;
    private final int zzaEo;
    private final int zzaEp;
    public static final zzo CREATOR = new zzo();

    public ParcelableGeofence(int version, String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        ParcelableGeofence.zzdx(requestId);
        ParcelableGeofence.zze(radius);
        ParcelableGeofence.zza(latitude, longitude);
        transitionTypes = ParcelableGeofence.zzhc(transitionTypes);
        this.mVersionCode = version;
        this.zzaEk = type;
        this.zzBY = requestId;
        this.zzaEl = latitude;
        this.zzaEm = longitude;
        this.zzaEn = radius;
        this.zzaFO = expireAt;
        this.zzaEi = transitionTypes;
        this.zzaEo = notificationResponsiveness;
        this.zzaEp = loiteringDelayMillis;
    }

    public ParcelableGeofence(String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        this(1, requestId, transitionTypes, type, latitude, longitude, radius, expireAt, notificationResponsiveness, loiteringDelayMillis);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public short zzwI() {
        return this.zzaEk;
    }

    public double getLatitude() {
        return this.zzaEl;
    }

    public double getLongitude() {
        return this.zzaEm;
    }

    public float zzwJ() {
        return this.zzaEn;
    }

    @Override
    public String getRequestId() {
        return this.zzBY;
    }

    public long getExpirationTime() {
        return this.zzaFO;
    }

    public int zzwK() {
        return this.zzaEi;
    }

    public int getNotificationResponsiveness() {
        return this.zzaEo;
    }

    public int zzwL() {
        return this.zzaEp;
    }

    private static void zzdx(String string) {
        if (string == null || string.length() > 100) {
            throw new IllegalArgumentException("requestId is null or too long: " + string);
        }
    }

    private static void zze(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + f);
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + d);
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + d2);
        }
    }

    private static int zzhc(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException("No supported transition specified: " + n);
        }
        return n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzo.zza(this, parcel, flags);
    }

    private static String zzhd(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static ParcelableGeofence zzn(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        ParcelableGeofence parcelableGeofence = CREATOR.zzeJ(parcel);
        parcel.recycle();
        return parcelableGeofence;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", ParcelableGeofence.zzhd(this.zzaEk), this.zzBY, this.zzaEi, this.zzaEl, this.zzaEm, Float.valueOf(this.zzaEn), this.zzaEo / 1000, this.zzaEp, this.zzaFO);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.zzaEl);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzaEm);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + Float.floatToIntBits(this.zzaEn);
        n2 = 31 * n2 + this.zzaEk;
        n2 = 31 * n2 + this.zzaEi;
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParcelableGeofence)) {
            return false;
        }
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)obj;
        if (this.zzaEn != parcelableGeofence.zzaEn) {
            return false;
        }
        if (this.zzaEl != parcelableGeofence.zzaEl) {
            return false;
        }
        if (this.zzaEm != parcelableGeofence.zzaEm) {
            return false;
        }
        return this.zzaEk == parcelableGeofence.zzaEk;
    }
}

