/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.places.zzb;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddPlaceRequest
implements SafeParcelable {
    final int mVersionCode;
    private final String mName;
    private final LatLng zzaFS;
    private final String zzapU;
    private final List<Integer> zzaFT;
    private final String zzaFU;
    private final Uri zzaFV;
    public static final Parcelable.Creator<AddPlaceRequest> CREATOR = new zzb();

    AddPlaceRequest(int versionCode, String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber, Uri websiteUri) {
        this.mVersionCode = versionCode;
        this.mName = zzx.zzcr((String)name);
        this.zzaFS = (LatLng)zzx.zzw((Object)latLng);
        this.zzapU = zzx.zzcr((String)address);
        this.zzaFT = new ArrayList<Integer>((Collection)zzx.zzw(placeTypes));
        zzx.zzb((!this.zzaFT.isEmpty() ? 1 : 0) != 0, (Object)"At least one place type should be provided.");
        zzx.zzb((!TextUtils.isEmpty((CharSequence)phoneNumber) || websiteUri != null ? 1 : 0) != 0, (Object)"One of phone number or URI should be provided.");
        this.zzaFU = phoneNumber;
        this.zzaFV = websiteUri;
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber) {
        this(name, latLng, address, placeTypes, zzx.zzcr((String)phoneNumber), null);
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, Uri uri) {
        this(name, latLng, address, placeTypes, null, (Uri)zzx.zzw((Object)uri));
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber, Uri uri) {
        this(0, name, latLng, address, placeTypes, phoneNumber, uri);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzb.zza(this, parcel, flags);
    }

    public String getName() {
        return this.mName;
    }

    public LatLng getLatLng() {
        return this.zzaFS;
    }

    public String getAddress() {
        return this.zzapU;
    }

    public List<Integer> getPlaceTypes() {
        return this.zzaFT;
    }

    public String getPhoneNumber() {
        return this.zzaFU;
    }

    public Uri getWebsiteUri() {
        return this.zzaFV;
    }

    public String toString() {
        return zzw.zzv((Object)this).zzg("name", (Object)this.mName).zzg("latLng", (Object)this.zzaFS).zzg("address", (Object)this.zzapU).zzg("placeTypes", this.zzaFT).zzg("phoneNumer", (Object)this.zzaFU).zzg("websiteUri", (Object)this.zzaFV).toString();
    }
}

