/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.location.internal.ParcelableGeofence;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzDX = null;
        private int zzaKO = 0;
        private long zzaKP = Long.MIN_VALUE;
        private short zzaKQ = (short)-1;
        private double zzaKR;
        private double zzaKS;
        private float zzaKT;
        private int zzaKU = 0;
        private int zzaKV = -1;

        public Builder setRequestId(String requestId) {
            this.zzDX = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.zzaKO = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.zzaKP = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.zzaKQ = 1;
            this.zzaKR = latitude;
            this.zzaKS = longitude;
            this.zzaKT = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.zzaKU = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.zzaKV = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.zzDX == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzaKO == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzaKO & 4) != 0 && this.zzaKV < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzaKP == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzaKQ == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzaKU < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new ParcelableGeofence(this.zzDX, this.zzaKO, 1, this.zzaKR, this.zzaKS, this.zzaKT, this.zzaKP, this.zzaKU, this.zzaKV);
        }
    }
}

