/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.places.zzb;
import com.google.android.gms.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddPlaceRequest
implements SafeParcelable {
    final int mVersionCode;
    private final String mName;
    private final LatLng zzaMo;
    private final String zzatX;
    private final List<Integer> zzaMp;
    private final String zzaMq;
    private final Uri zzaMr;
    public static final Parcelable.Creator<AddPlaceRequest> CREATOR = new zzb();

    AddPlaceRequest(int versionCode, String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber, Uri websiteUri) {
        this.mVersionCode = versionCode;
        this.mName = zzx.zzcG((String)name);
        this.zzaMo = (LatLng)zzx.zzy((Object)latLng);
        this.zzatX = zzx.zzcG((String)address);
        this.zzaMp = new ArrayList<Integer>((Collection)zzx.zzy(placeTypes));
        zzx.zzb((!this.zzaMp.isEmpty() ? 1 : 0) != 0, (Object)"At least one place type should be provided.");
        zzx.zzb((!TextUtils.isEmpty((CharSequence)phoneNumber) || websiteUri != null ? 1 : 0) != 0, (Object)"One of phone number or URI should be provided.");
        this.zzaMq = phoneNumber;
        this.zzaMr = websiteUri;
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber) {
        this(name, latLng, address, placeTypes, zzx.zzcG((String)phoneNumber), null);
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, Uri uri) {
        this(name, latLng, address, placeTypes, null, (Uri)zzx.zzy((Object)uri));
    }

    public AddPlaceRequest(String name, LatLng latLng, String address, List<Integer> placeTypes, String phoneNumber, Uri uri) {
        this(0, name, latLng, address, placeTypes, phoneNumber, uri);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzb.zza(this, parcel, flags);
    }

    public String getName() {
        return this.mName;
    }

    public LatLng getLatLng() {
        return this.zzaMo;
    }

    public String getAddress() {
        return this.zzatX;
    }

    public List<Integer> getPlaceTypes() {
        return this.zzaMp;
    }

    public String getPhoneNumber() {
        return this.zzaMq;
    }

    public Uri getWebsiteUri() {
        return this.zzaMr;
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("name", (Object)this.mName).zzg("latLng", (Object)this.zzaMo).zzg("address", (Object)this.zzatX).zzg("placeTypes", this.zzaMp).zzg("phoneNumer", (Object)this.zzaMq).zzg("websiteUri", (Object)this.zzaMr).toString();
    }
}

