/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.ParcelableGeofence;
import java.util.ArrayList;
import java.util.List;

public class GeofencingEvent {
    private final int zzGu;
    private final int zzaNK;
    private final List<Geofence> zzaNL;
    private final Location zzaNM;

    private GeofencingEvent(int errorCode, int transitionType, List<Geofence> triggeringGeofences, Location triggeringLocaton) {
        this.zzGu = errorCode;
        this.zzaNK = transitionType;
        this.zzaNL = triggeringGeofences;
        this.zzaNM = triggeringLocaton;
    }

    public static GeofencingEvent fromIntent(Intent intent) {
        if (intent == null) {
            return null;
        }
        int n = intent.getIntExtra("gms_error_code", -1);
        int n2 = GeofencingEvent.zzx(intent);
        List<Geofence> list = GeofencingEvent.zzy(intent);
        Location location = (Location)intent.getParcelableExtra("com.google.android.location.intent.extra.triggering_location");
        return new GeofencingEvent(n, n2, list, location);
    }

    private static int zzx(Intent intent) {
        int n = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n == -1) {
            return -1;
        }
        if (n == 1 || n == 2 || n == 4) {
            return n;
        }
        return -1;
    }

    private static List<Geofence> zzy(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(ParcelableGeofence.zzo(byArray));
        }
        return arrayList2;
    }

    public boolean hasError() {
        return this.zzGu != -1;
    }

    public int getErrorCode() {
        return this.zzGu;
    }

    public int getGeofenceTransition() {
        return this.zzaNK;
    }

    public List<Geofence> getTriggeringGeofences() {
        return this.zzaNL;
    }

    public Location getTriggeringLocation() {
        return this.zzaNM;
    }
}

