/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.zzf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class LocationSettingsRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final List<LocationRequest> zzaBm;
    private final boolean zzaOf;
    private final boolean zzaOg;
    public static final Parcelable.Creator<LocationSettingsRequest> CREATOR = new zzf();

    LocationSettingsRequest(int version, List<LocationRequest> locationRequests, boolean alwaysShow, boolean needBle) {
        this.mVersionCode = version;
        this.zzaBm = locationRequests;
        this.zzaOf = alwaysShow;
        this.zzaOg = needBle;
    }

    private LocationSettingsRequest(List<LocationRequest> locationRequests, boolean alwaysShow, boolean needBle) {
        this(3, locationRequests, alwaysShow, needBle);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public List<LocationRequest> zzuZ() {
        return Collections.unmodifiableList(this.zzaBm);
    }

    public boolean zzyK() {
        return this.zzaOf;
    }

    public boolean zzyL() {
        return this.zzaOg;
    }

    public static final class Builder {
        private final ArrayList<LocationRequest> zzaOh = new ArrayList();
        private boolean zzaOf = false;
        private boolean zzaOg = false;

        public Builder addLocationRequest(LocationRequest request) {
            this.zzaOh.add(request);
            return this;
        }

        public Builder addAllLocationRequests(Collection<LocationRequest> requests) {
            this.zzaOh.addAll(requests);
            return this;
        }

        public Builder setAlwaysShow(boolean show) {
            this.zzaOf = show;
            return this;
        }

        public Builder setNeedBle(boolean needBle) {
            this.zzaOg = needBle;
            return this;
        }

        public LocationSettingsRequest build() {
            return new LocationSettingsRequest(this.zzaOh, this.zzaOf, this.zzaOg);
        }
    }
}

