/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzh;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzj;
import com.google.android.gms.location.internal.zzk;
import java.util.List;

public class zzl
extends com.google.android.gms.location.internal.zzb {
    private final zzk zzaOM;

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzf.zzat((Context)context));
    }

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zzf zzf2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zzf2);
        this.zzaOM = new zzk(context, this.zzaOt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzk zzk2 = this.zzaOM;
        synchronized (zzk2) {
            if (this.isConnected()) {
                try {
                    this.zzaOM.removeAllListeners();
                    this.zzaOM.zzyP();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zzqI();
        zzx.zzz((Object)pendingIntent);
        zzx.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzi)this.zzqJ()).zza(l, true, pendingIntent);
    }

    public void zza(PendingIntent pendingIntent) throws RemoteException {
        this.zzqI();
        zzx.zzz((Object)pendingIntent);
        ((zzi)this.zzqJ()).zza(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zza.zzb<Status> zzb2) throws RemoteException {
        this.zzqI();
        zzx.zzb((Object)geofencingRequest, (Object)"geofencingRequest can't be null.");
        zzx.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        zza zza2 = new zza(zzb2);
        ((zzi)this.zzqJ()).zza(geofencingRequest, pendingIntent, zza2);
    }

    public void zza(PendingIntent pendingIntent, zza.zzb<Status> zzb2) throws RemoteException {
        this.zzqI();
        zzx.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zzqJ()).zza(pendingIntent, (zzh)zzb3, this.getContext().getPackageName());
    }

    public void zza(List<String> list, zza.zzb<Status> zzb2) throws RemoteException {
        this.zzqI();
        zzx.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"geofenceRequestIds can't be null nor empty.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zzqJ()).zza(stringArray, (zzh)zzb3, this.getContext().getPackageName());
    }

    public Location getLastLocation() {
        return this.zzaOM.getLastLocation();
    }

    public LocationAvailability zzyO() {
        return this.zzaOM.zzyO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.zzaOM;
        synchronized (zzk2) {
            this.zzaOM.zza(locationRequestInternal, locationCallback, looper, zzg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.zzaOM;
        synchronized (zzk2) {
            this.zzaOM.zza(locationRequest, locationListener, looper, zzg2);
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaOM.zza(locationRequest, pendingIntent, zzg2);
    }

    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.zzaOM.zza(locationListener, zzg2);
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaOM.zza(pendingIntent, zzg2);
    }

    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.zzaOM.zza(locationCallback, zzg2);
    }

    public void zzam(boolean bl) throws RemoteException {
        this.zzaOM.zzam(bl);
    }

    public void zzc(Location location) throws RemoteException {
        this.zzaOM.zzc(location);
    }

    public void zza(zzg zzg2) throws RemoteException {
        this.zzaOM.zza(zzg2);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zza.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zzqI();
        zzx.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzx.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzc zzc2 = new zzc(zzb2);
        ((zzi)this.zzqJ()).zza(locationSettingsRequest, zzc2, string);
    }

    private static final class zzc
    extends zzj.zza {
        private zza.zzb<LocationSettingsResult> zzaON;

        public zzc(zza.zzb<LocationSettingsResult> zzb2) {
            zzx.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.zzaON = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzaON.zzs((Object)locationSettingsResult);
            this.zzaON = null;
        }
    }

    private static final class zzb
    extends zzh.zza {
        private zza.zzb<Status> zzaON;

        public zzb(zza.zzb<Status> zzb2) {
            this.zzaON = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onAddGeofencesResult");
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            this.zzhC(n);
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            this.zzhC(n);
        }

        private void zzhC(int n) {
            if (this.zzaON == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzhz(LocationStatusCodes.zzhy(n));
            this.zzaON.zzs((Object)status);
            this.zzaON = null;
        }
    }

    private static final class zza
    extends zzh.zza {
        private zza.zzb<Status> zzaON;

        public zza(zza.zzb<Status> zzb2) {
            this.zzaON = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            if (this.zzaON == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzhz(LocationStatusCodes.zzhy(n));
            this.zzaON.zzs((Object)status);
            this.zzaON = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByRequestIdsResult");
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByPendingIntentResult");
        }
    }
}

