/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.location.ActivityRecognitionResultCreator;
import com.google.android.gms.location.DetectedActivity;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
extends AbstractSafeParcelable {
    public static final ActivityRecognitionResultCreator CREATOR = new ActivityRecognitionResultCreator();
    private final int mVersionCode;
    List<DetectedActivity> zzaUJ;
    long zzaUK;
    long zzaUL;
    int zzaUM;
    Bundle extras;

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2) {
        this(list, l, l2, 0, null);
    }

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2, int n, Bundle bundle) {
        zzaa.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 detected activity");
        zzaa.zzb((l > 0L && l2 > 0L ? 1 : 0) != 0, (Object)"Must set times");
        this.mVersionCode = 2;
        this.zzaUJ = list;
        this.zzaUK = l;
        this.zzaUL = l2;
        this.zzaUM = n;
        this.extras = bundle;
    }

    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2) {
        this(detectedActivity, l, l2, 0, null);
    }

    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2, int n, Bundle bundle) {
        this(Collections.singletonList(detectedActivity), l, l2, n, bundle);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        Object object = intent.getExtras().get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
        if (object instanceof byte[]) {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall((byte[])object, 0, ((byte[])object).length);
            parcel.setDataPosition(0);
            return (ActivityRecognitionResult)((Object)CREATOR.createFromParcel(parcel));
        }
        if (object instanceof ActivityRecognitionResult) {
            return (ActivityRecognitionResult)((Object)object);
        }
        return null;
    }

    public DetectedActivity getMostProbableActivity() {
        return this.zzaUJ.get(0);
    }

    public int getActivityConfidence(int n) {
        for (DetectedActivity detectedActivity : this.zzaUJ) {
            if (detectedActivity.getType() != n) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.zzaUJ;
    }

    public long getTime() {
        return this.zzaUK;
    }

    public long getElapsedRealtimeMillis() {
        return this.zzaUL;
    }

    public String toString() {
        String string = String.valueOf(this.zzaUJ);
        long l = this.zzaUK;
        long l2 = this.zzaUL;
        return new StringBuilder(124 + String.valueOf(string).length()).append("ActivityRecognitionResult [probableActivities=").append(string).append(", timeMillis=").append(l).append(", elapsedRealtimeMillis=").append(l2).append("]").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)((Object)object);
        return this.zzaUK == activityRecognitionResult.zzaUK && this.zzaUL == activityRecognitionResult.zzaUL && this.zzaUM == activityRecognitionResult.zzaUM && zzz.equal(this.zzaUJ, activityRecognitionResult.zzaUJ) && ActivityRecognitionResult.zzc(this.extras, activityRecognitionResult.extras);
    }

    private static boolean zzc(Bundle bundle, Bundle bundle2) {
        if (bundle == null && bundle2 == null) {
            return true;
        }
        if (bundle == null && bundle2 != null || bundle != null && bundle2 == null) {
            return false;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            if (!bundle2.containsKey(string)) {
                return false;
            }
            if (!(bundle.get(string) == null ? bundle2.get(string) != null : (bundle.get(string) instanceof Bundle ? !ActivityRecognitionResult.zzc(bundle.getBundle(string), bundle2.getBundle(string)) : !bundle.get(string).equals(bundle2.get(string))))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaUK, this.zzaUL, this.zzaUM, this.zzaUJ, this.extras});
    }

    public ActivityRecognitionResult(int n, List<DetectedActivity> list, long l, long l2, int n2, Bundle bundle) {
        this.mVersionCode = n;
        this.zzaUJ = list;
        this.zzaUK = l;
        this.zzaUL = l2;
        this.zzaUM = n2;
        this.extras = bundle;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel parcel, int n) {
        ActivityRecognitionResultCreator.zza(this, parcel, n);
    }
}

