/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
extends AbstractSafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int mVersionCode;
    int mPriority;
    long zzaVo;
    long zzaVp;
    boolean zzaIe;
    long zzaUT;
    int zzaVq;
    float zzaVr;
    long zzaVs;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mVersionCode = 1;
        this.mPriority = 102;
        this.zzaVo = 3600000L;
        this.zzaVp = 600000L;
        this.zzaIe = false;
        this.zzaUT = Long.MAX_VALUE;
        this.zzaVq = Integer.MAX_VALUE;
        this.zzaVr = 0.0f;
        this.zzaVs = 0L;
    }

    public LocationRequest setPriority(int n) {
        LocationRequest.zzhV(n);
        this.mPriority = n;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long l) {
        LocationRequest.zzQ(l);
        this.zzaVo = l;
        if (!this.zzaIe) {
            this.zzaVp = (long)((double)this.zzaVo / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzaVo;
    }

    public LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzQ(l);
        this.zzaVs = l;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzaVs;
        if (l < this.zzaVo) {
            l = this.zzaVo;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long l) {
        LocationRequest.zzQ(l);
        this.zzaIe = true;
        this.zzaVp = l;
        return this;
    }

    public long getFastestInterval() {
        return this.zzaVp;
    }

    public LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzaUT = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzaUT < 0L) {
            this.zzaUT = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long l) {
        this.zzaUT = l;
        if (this.zzaUT < 0L) {
            this.zzaUT = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzaUT;
    }

    public LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzaVq = n;
        return this;
    }

    public int getNumUpdates() {
        return this.zzaVq;
    }

    public LocationRequest setSmallestDisplacement(float f) {
        LocationRequest.zzd(f);
        this.zzaVr = f;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzaVr;
    }

    private static void zzQ(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    private static void zzhV(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
    }

    private static void zzd(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
    }

    LocationRequest(int n, int n2, long l, long l2, boolean bl, long l3, int n3, float f, long l4) {
        this.mVersionCode = n;
        this.mPriority = n2;
        this.zzaVo = l;
        this.zzaVp = l2;
        this.zzaIe = bl;
        this.zzaUT = l3;
        this.zzaVq = n3;
        this.zzaVr = f;
        this.zzaVs = l4;
    }

    public void writeToParcel(Parcel parcel, int n) {
        LocationRequestCreator.zza(this, parcel, n);
    }

    public static String zzhW(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzhW(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzaVo).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzaVp).append("ms");
        if (this.zzaVs > this.zzaVo) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzaVs).append("ms");
        }
        if (this.zzaUT != Long.MAX_VALUE) {
            long l = this.zzaUT - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzaVq != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzaVq);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.mPriority, this.zzaVo, this.zzaVp, this.zzaIe, this.zzaUT, this.zzaVq, Float.valueOf(this.zzaVr)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzaVo == locationRequest.zzaVo && this.zzaVp == locationRequest.zzaVp && this.zzaIe == locationRequest.zzaIe && this.zzaUT == locationRequest.zzaUT && this.zzaVq == locationRequest.zzaVq && this.zzaVr == locationRequest.zzaVr;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }
}

