/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.LocationRequestUpdateData;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzp;
import com.google.android.gms.location.zzd;
import com.google.android.gms.location.zze;
import java.util.HashMap;
import java.util.Map;

public class zzk {
    private final zzp<zzi> zzaVJ;
    private final Context mContext;
    private ContentProviderClient zzaVW = null;
    private boolean zzaVX = false;
    private Map<LocationListener, zzc> zzaDR = new HashMap<LocationListener, zzc>();
    private Map<LocationCallback, zza> zzaVY = new HashMap<LocationCallback, zza>();

    public zzk(Context context, zzp<zzi> zzp2) {
        this.mContext = context;
        this.zzaVJ = zzp2;
    }

    public Location getLastLocation() {
        this.zzaVJ.zztl();
        try {
            Location location = this.zzaVJ.zztm().zzeJ(this.mContext.getPackageName());
            return location;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public LocationAvailability zzCw() {
        this.zzaVJ.zztl();
        try {
            return this.zzaVJ.zztm().zzeK(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        this.zzaVJ.zztl();
        zzc zzc2 = this.zza(locationListener, looper);
        this.zzaVJ.zztm().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), zzc2, zzg2));
    }

    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        this.zzaVJ.zztl();
        zza zza2 = this.zza(locationCallback, looper);
        this.zzaVJ.zztm().zza(LocationRequestUpdateData.zza(locationRequestInternal, zza2, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zza(LocationListener locationListener, Looper looper) {
        Map<LocationListener, zzc> map = this.zzaDR;
        synchronized (map) {
            zzc zzc2 = this.zzaDR.get(locationListener);
            if (zzc2 == null) {
                zzc2 = new zzc(locationListener, looper);
            }
            this.zzaDR.put(locationListener, zzc2);
            return zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zza zza(LocationCallback locationCallback, Looper looper) {
        Map<LocationCallback, zza> map = this.zzaVY;
        synchronized (map) {
            zza zza2 = this.zzaVY.get(locationCallback);
            if (zza2 == null) {
                zza2 = new zza(locationCallback, looper);
            }
            this.zzaVY.put(locationCallback, zza2);
            return zza2;
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaVJ.zztl();
        this.zzaVJ.zztm().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), pendingIntent, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.zzaVJ.zztl();
        zzaa.zzb((Object)locationListener, (Object)"Invalid null listener");
        Map<LocationListener, zzc> map = this.zzaDR;
        synchronized (map) {
            zzc zzc2 = this.zzaDR.remove(locationListener);
            if (zzc2 != null) {
                zzc2.release();
                this.zzaVJ.zztm().zza(LocationRequestUpdateData.zza(zzc2, zzg2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.zzaVJ.zztl();
        zzaa.zzb((Object)locationCallback, (Object)"Invalid null callback");
        Map<LocationCallback, zza> map = this.zzaVY;
        synchronized (map) {
            zza zza2 = this.zzaVY.remove(locationCallback);
            if (zza2 != null) {
                zza2.release();
                this.zzaVJ.zztm().zza(LocationRequestUpdateData.zza(zza2, zzg2));
            }
        }
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaVJ.zztl();
        this.zzaVJ.zztm().zza(LocationRequestUpdateData.zzb(pendingIntent, zzg2));
    }

    public void zzat(boolean bl) throws RemoteException {
        this.zzaVJ.zztl();
        this.zzaVJ.zztm().zzat(bl);
        this.zzaVX = bl;
    }

    public void zzc(Location location) throws RemoteException {
        this.zzaVJ.zztl();
        this.zzaVJ.zztm().zzc(location);
    }

    public void zza(zzg zzg2) throws RemoteException {
        this.zzaVJ.zztl();
        this.zzaVJ.zztm().zza(zzg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            Map<Object, Binder> map = this.zzaDR;
            synchronized (map) {
                for (zzc binder : this.zzaDR.values()) {
                    if (binder == null) continue;
                    this.zzaVJ.zztm().zza(LocationRequestUpdateData.zza(binder, null));
                }
                this.zzaDR.clear();
            }
            map = this.zzaVY;
            synchronized (map) {
                for (zza zza2 : this.zzaVY.values()) {
                    if (zza2 == null) continue;
                    this.zzaVJ.zztm().zza(LocationRequestUpdateData.zza(zza2, null));
                }
                this.zzaVY.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzCx() {
        if (this.zzaVX) {
            try {
                this.zzat(false);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    private static class zzb
    extends Handler {
        private final LocationListener zzaWb;

        public zzb(LocationListener locationListener) {
            this.zzaWb = locationListener;
        }

        public zzb(LocationListener locationListener, Looper looper) {
            super(looper);
            this.zzaWb = locationListener;
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Location location = new Location((Location)message.obj);
                    this.zzaWb.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class zza
    extends zzd.zza {
        private Handler zzaVZ;

        zza(final LocationCallback locationCallback, Looper looper) {
            if (looper == null) {
                looper = Looper.myLooper();
                zzaa.zza((looper != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaVZ = new Handler(looper){

                public void handleMessage(Message message) {
                    switch (message.what) {
                        case 0: {
                            locationCallback.onLocationResult((LocationResult)((Object)message.obj));
                            break;
                        }
                        case 1: {
                            locationCallback.onLocationAvailability((LocationAvailability)((Object)message.obj));
                        }
                    }
                }
            };
        }

        @Override
        public void onLocationResult(LocationResult locationResult) {
            this.zzb(0, (Object)locationResult);
        }

        @Override
        public void onLocationAvailability(LocationAvailability locationAvailability) {
            this.zzb(1, (Object)locationAvailability);
        }

        public void release() {
            this.zzaVZ = null;
        }

        private void zzb(int n, Object object) {
            if (this.zzaVZ == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a data in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = n;
            message.obj = object;
            this.zzaVZ.sendMessage(message);
        }
    }

    private static class zzc
    extends zze.zza {
        private Handler zzaVZ;

        zzc(LocationListener locationListener, Looper looper) {
            if (looper == null) {
                zzaa.zza((Looper.myLooper() != null ? 1 : 0) != 0, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaVZ = looper == null ? new zzb(locationListener) : new zzb(locationListener, looper);
        }

        @Override
        public void onLocationChanged(Location location) {
            if (this.zzaVZ == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.zzaVZ.sendMessage(message);
        }

        public void release() {
            this.zzaVZ = null;
        }
    }
}

