/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzai;
import com.google.android.gms.maps.internal.zzt;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzbnV;

    public MapView(Context context) {
        super(context);
        this.zzbnV = new zzb((ViewGroup)this, context, null);
        this.zzIM();
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbnV = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzIM();
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbnV = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attributeSet));
        this.zzIM();
    }

    public MapView(Context context, GoogleMapOptions googleMapOptions) {
        super(context);
        this.zzbnV = new zzb((ViewGroup)this, context, googleMapOptions);
        this.zzIM();
    }

    private void zzIM() {
        this.setClickable(true);
    }

    public final void onCreate(Bundle bundle) {
        this.zzbnV.onCreate(bundle);
        if (this.zzbnV.zzAY() == null) {
            com.google.android.gms.dynamic.zza.zzb((FrameLayout)this);
        }
    }

    public final void onResume() {
        this.zzbnV.onResume();
    }

    public final void onPause() {
        this.zzbnV.onPause();
    }

    public final void onStart() {
        this.zzbnV.onStart();
    }

    public final void onStop() {
        this.zzbnV.onStop();
    }

    public final void onDestroy() {
        this.zzbnV.onDestroy();
    }

    public final void onLowMemory() {
        this.zzbnV.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle bundle) {
        this.zzbnV.onSaveInstanceState(bundle);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzac.zzdn((String)"getMapAsync() must be called on the main thread");
        this.zzbnV.getMapAsync(onMapReadyCallback);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzac.zzdn((String)"onEnterAmbient() must be called on the main thread");
        this.zzbnV.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzac.zzdn((String)"onExitAmbient() must be called on the main thread");
        this.zzbnV.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzbnZ;
        private final Context mContext;
        protected zzf<zza> zzbnT;
        private final GoogleMapOptions zzboa;
        private final List<OnMapReadyCallback> zzbnU = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzbnZ = viewGroup;
            this.mContext = context;
            this.zzboa = googleMapOptions;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzbnT = zzf2;
            this.zzIL();
        }

        public void zzIL() {
            if (this.zzbnT != null && this.zzAY() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzai.zzbq(this.mContext).zza(zze.zzA((Object)this.mContext), this.zzboa);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzbnT.zza((LifecycleDelegate)new zza(this.zzbnZ, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzbnU) {
                        ((zza)this.zzAY()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzbnU.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzAY() != null) {
                ((zza)this.zzAY()).getMapAsync(onMapReadyCallback);
            } else {
                this.zzbnU.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzAY() != null) {
                ((zza)this.zzAY()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzAY() != null) {
                ((zza)this.zzAY()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzbnW;
        private final IMapViewDelegate zzbnX;
        private View zzbnY;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzbnX = (IMapViewDelegate)zzac.zzw((Object)iMapViewDelegate);
            this.zzbnW = (ViewGroup)zzac.zzw((Object)viewGroup);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        public void onCreate(Bundle bundle) {
            try {
                this.zzbnX.onCreate(bundle);
                this.zzbnY = (View)zze.zzE((zzd)this.zzbnX.getView());
                this.zzbnW.removeAllViews();
                this.zzbnW.addView(this.zzbnY);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        public void onStart() {
            try {
                this.zzbnX.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbnX.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbnX.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbnX.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        public void onDestroy() {
            try {
                this.zzbnX.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzbnX.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzbnX.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzbnX.getMapAsync(new zzt.zza(this){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.zzbnX.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzbnX.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

