/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zza {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zzbnt;
    private LatLng zzbnu;
    private float zzbnv;
    private float zzbnw;
    private LatLngBounds zzblu;
    private float zzbnj;
    private float zzbno;
    private boolean zzbnp = true;
    private float zzbnx = 0.0f;
    private float zzbny = 0.5f;
    private float zzbnz = 0.5f;
    private boolean zzbnq = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zzbnt = new BitmapDescriptor(IObjectWrapper.zza.zzM((IBinder)iBinder));
        this.zzbnu = latLng;
        this.zzbnv = f;
        this.zzbnw = f2;
        this.zzblu = latLngBounds;
        this.zzbnj = f3;
        this.zzbno = f4;
        this.zzbnp = bl;
        this.zzbnx = f5;
        this.zzbny = f6;
        this.zzbnz = f7;
        this.zzbnq = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = com.google.android.gms.common.internal.safeparcel.zzd.zze((Parcel)parcel2);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zzbnt.zzwd().asBinder(), (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        com.google.android.gms.common.internal.safeparcel.zzd.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        com.google.android.gms.common.internal.safeparcel.zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbr.zzb((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zzbnt = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zzbny = f;
        this.zzbnz = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbr.zza((this.zzblu == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbr.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbr.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbr.zza((this.zzblu == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbr.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbr.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbr.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zzbnu = latLng;
        this.zzbnv = f;
        this.zzbnw = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zzbnu);
        zzbr.zza((this.zzbnu == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zzblu = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zzbnj = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zzbno = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zzbnp = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbr.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zzbnx = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zzbnq = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zzbnt;
    }

    public final LatLng getLocation() {
        return this.zzbnu;
    }

    public final float getWidth() {
        return this.zzbnv;
    }

    public final float getHeight() {
        return this.zzbnw;
    }

    public final LatLngBounds getBounds() {
        return this.zzblu;
    }

    public final float getBearing() {
        return this.zzbnj;
    }

    public final float getZIndex() {
        return this.zzbno;
    }

    public final float getTransparency() {
        return this.zzbnx;
    }

    public final float getAnchorU() {
        return this.zzbny;
    }

    public final float getAnchorV() {
        return this.zzbnz;
    }

    public final boolean isVisible() {
        return this.zzbnp;
    }

    public final boolean isClickable() {
        return this.zzbnq;
    }
}

