/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zze;
import java.util.Arrays;

public final class LatLngBounds
extends zzbgl
implements ReflectedParcelable {
    @Hide
    public static final Parcelable.Creator<LatLngBounds> CREATOR = new zze();
    public final LatLng southwest;
    public final LatLng northeast;

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        zzbq.zza((Object)((Object)latLng), (Object)"null southwest");
        zzbq.zza((Object)((Object)latLng2), (Object)"null northeast");
        zzbq.zzb((latLng2.latitude >= latLng.latitude ? 1 : 0) != 0, (String)"southern latitude exceeds northern latitude (%s > %s)", (Object[])new Object[]{latLng.latitude, latLng2.latitude});
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LatLngBounds latLngBounds = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)latLngBounds.southwest, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)latLngBounds.northeast, (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public final boolean contains(LatLng latLng) {
        LatLngBounds latLngBounds;
        LatLng latLng2 = latLng;
        double d = latLng2.latitude;
        LatLngBounds latLngBounds2 = this;
        return latLngBounds.southwest.latitude <= d && d <= latLngBounds2.northeast.latitude && this.zza(latLng2.longitude);
    }

    public final LatLngBounds including(LatLng latLng) {
        LatLng latLng2 = latLng;
        double d = Math.min(this.southwest.latitude, latLng2.latitude);
        double d2 = Math.max(this.northeast.latitude, latLng2.latitude);
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = latLng2.longitude;
        if (!this.zza(d5)) {
            if (LatLngBounds.zzc(d4, d5) < LatLngBounds.zzd(d3, d5)) {
                d4 = d5;
            } else {
                d3 = d5;
            }
        }
        return new LatLngBounds(new LatLng(d, d4), new LatLng(d2, d3));
    }

    public final LatLng getCenter() {
        double d;
        double d2 = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d3 = this.northeast.longitude;
        double d4 = this.southwest.longitude;
        double d5 = d <= d3 ? (d3 + d4) / 2.0 : (d3 + 360.0 + d4) / 2.0;
        return new LatLng(d2, d5);
    }

    private static double zzc(double d, double d2) {
        return (d - d2 + 360.0) % 360.0;
    }

    private static double zzd(double d, double d2) {
        return (d2 - d + 360.0) % 360.0;
    }

    private final boolean zza(double d) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d && d <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d || d <= this.northeast.longitude;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.southwest, this.northeast});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)((Object)object);
        return this.southwest.equals((Object)latLngBounds.southwest) && this.northeast.equals((Object)latLngBounds.northeast);
    }

    public final String toString() {
        return zzbg.zza((Object)((Object)this)).zza("southwest", (Object)this.southwest).zza("northeast", (Object)this.northeast).toString();
    }

    public static LatLngBounds createFromAttributes(Context context, AttributeSet attributeSet) {
        if (context == null || attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        Float f = null;
        Float f2 = null;
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude)) {
            f = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude)) {
            f2 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude, 0.0f));
        }
        Float f3 = null;
        Float f4 = null;
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude)) {
            f3 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude)) {
            f4 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude, 0.0f));
        }
        if (f == null || f2 == null || f3 == null || f4 == null) {
            return null;
        }
        LatLng latLng = new LatLng(f.floatValue(), f2.floatValue());
        LatLng latLng2 = new LatLng(f3.floatValue(), f4.floatValue());
        return new LatLngBounds(latLng, latLng2);
    }

    public static final class Builder {
        private double zza = Double.POSITIVE_INFINITY;
        private double zzb = Double.NEGATIVE_INFINITY;
        private double zzc = Double.NaN;
        private double zzd = Double.NaN;

        public Builder() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public final Builder include(LatLng latLng) {
            this.zza = Math.min(this.zza, latLng.latitude);
            this.zzb = Math.max(this.zzb, latLng.latitude);
            double d = latLng.longitude;
            if (Double.isNaN(this.zzc)) {
                this.zzc = d;
            } else {
                Builder builder;
                Builder builder2 = this;
                if (builder.zzc <= builder2.zzd ? builder2.zzc <= d && d <= builder2.zzd : builder2.zzc <= d || d <= builder2.zzd) return this;
                if (LatLngBounds.zzc(this.zzc, d) < LatLngBounds.zzd(this.zzd, d)) {
                    this.zzc = d;
                    return this;
                }
            }
            this.zzd = d;
            return this;
        }

        public final LatLngBounds build() {
            zzbq.zza((!Double.isNaN(this.zzc) ? 1 : 0) != 0, (Object)"no included points");
            return new LatLngBounds(new LatLng(this.zza, this.zzc), new LatLng(this.zzb, this.zzd));
        }
    }
}

