/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.R;
import com.google.android.gms.maps.internal.zza;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.zzaa;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GoogleMapOptionsCreator")
public final class GoogleMapOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleMapOptions> CREATOR = new zzaa();
    @SafeParcelable.Field(id=2, getter="getZOrderOnTopForParcel", type="byte", defaultValue="-1")
    private Boolean zzaj;
    @SafeParcelable.Field(id=3, getter="getUseViewLifecycleInFragmentForParcel", type="byte", defaultValue="-1")
    private Boolean zzak;
    @SafeParcelable.Field(id=4, getter="getMapType")
    private int mapType = -1;
    @SafeParcelable.Field(id=5, getter="getCamera")
    private CameraPosition zzal;
    @SafeParcelable.Field(id=6, getter="getZoomControlsEnabledForParcel", type="byte", defaultValue="-1")
    private Boolean zzam;
    @SafeParcelable.Field(id=7, getter="getCompassEnabledForParcel", type="byte", defaultValue="-1")
    private Boolean zzan;
    @SafeParcelable.Field(id=8, getter="getScrollGesturesEnabledForParcel", type="byte", defaultValue="-1")
    private Boolean zzao;
    @SafeParcelable.Field(id=9, getter="getZoomGesturesEnabledForParcel", type="byte", defaultValue="-1")
    private Boolean zzap;
    @SafeParcelable.Field(id=10, getter="getTiltGesturesEnabledForParcel", type="byte", defaultValue="-1")
    private Boolean zzaq;
    @SafeParcelable.Field(id=11, getter="getRotateGesturesEnabledForParcel", type="byte", defaultValue="-1")
    private Boolean zzar;
    @SafeParcelable.Field(id=12, getter="getLiteModeForParcel", type="byte", defaultValue="-1")
    private Boolean zzas;
    @SafeParcelable.Field(id=14, getter="getMapToolbarEnabledForParcel", type="byte", defaultValue="-1")
    private Boolean zzat;
    @SafeParcelable.Field(id=15, getter="getAmbientEnabledForParcel", type="byte", defaultValue="-1")
    private Boolean zzau;
    @SafeParcelable.Field(id=16, getter="getMinZoomPreference")
    private Float zzav = null;
    @SafeParcelable.Field(id=17, getter="getMaxZoomPreference")
    private Float zzaw = null;
    @SafeParcelable.Field(id=18, getter="getLatLngBoundsForCameraTarget")
    private LatLngBounds zzax = null;
    @SafeParcelable.Field(id=19, getter="getScrollGesturesEnabledDuringRotateOrZoomForParcel", type="byte", defaultValue="-1")
    private Boolean zzay;

    @SafeParcelable.Constructor
    GoogleMapOptions(@SafeParcelable.Param(id=2) byte by, @SafeParcelable.Param(id=3) byte by2, @SafeParcelable.Param(id=4) int n, @SafeParcelable.Param(id=5) CameraPosition cameraPosition, @SafeParcelable.Param(id=6) byte by3, @SafeParcelable.Param(id=7) byte by4, @SafeParcelable.Param(id=8) byte by5, @SafeParcelable.Param(id=9) byte by6, @SafeParcelable.Param(id=10) byte by7, @SafeParcelable.Param(id=11) byte by8, @SafeParcelable.Param(id=12) byte by9, @SafeParcelable.Param(id=14) byte by10, @SafeParcelable.Param(id=15) byte by11, @SafeParcelable.Param(id=16) Float f, @SafeParcelable.Param(id=17) Float f2, @SafeParcelable.Param(id=18) LatLngBounds latLngBounds, @SafeParcelable.Param(id=19) byte by12) {
        this.zzaj = zza.zza(by);
        this.zzak = zza.zza(by2);
        this.mapType = n;
        this.zzal = cameraPosition;
        this.zzam = zza.zza(by3);
        this.zzan = zza.zza(by4);
        this.zzao = zza.zza(by5);
        this.zzap = zza.zza(by6);
        this.zzaq = zza.zza(by7);
        this.zzar = zza.zza(by8);
        this.zzas = zza.zza(by9);
        this.zzat = zza.zza(by10);
        this.zzau = zza.zza(by11);
        this.zzav = f;
        this.zzaw = f2;
        this.zzax = latLngBounds;
        this.zzay = zza.zza(by12);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleMapOptions googleMapOptions = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)2, (byte)zza.zza(googleMapOptions.zzaj));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)3, (byte)zza.zza(googleMapOptions.zzak));
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)googleMapOptions.getMapType());
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)googleMapOptions.getCamera(), (int)n, (boolean)false);
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)6, (byte)zza.zza(googleMapOptions.zzam));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)7, (byte)zza.zza(googleMapOptions.zzan));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)8, (byte)zza.zza(googleMapOptions.zzao));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)9, (byte)zza.zza(googleMapOptions.zzap));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)10, (byte)zza.zza(googleMapOptions.zzaq));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)11, (byte)zza.zza(googleMapOptions.zzar));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)12, (byte)zza.zza(googleMapOptions.zzas));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)14, (byte)zza.zza(googleMapOptions.zzat));
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)15, (byte)zza.zza(googleMapOptions.zzau));
        SafeParcelWriter.writeFloatObject((Parcel)parcel2, (int)16, (Float)googleMapOptions.getMinZoomPreference(), (boolean)false);
        SafeParcelWriter.writeFloatObject((Parcel)parcel2, (int)17, (Float)googleMapOptions.getMaxZoomPreference(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)18, (Parcelable)googleMapOptions.getLatLngBoundsForCameraTarget(), (int)n, (boolean)false);
        SafeParcelWriter.writeByte((Parcel)parcel2, (int)19, (byte)zza.zza(googleMapOptions.zzay));
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public GoogleMapOptions() {
    }

    public final GoogleMapOptions zOrderOnTop(boolean bl) {
        this.zzaj = bl;
        return this;
    }

    public final GoogleMapOptions useViewLifecycleInFragment(boolean bl) {
        this.zzak = bl;
        return this;
    }

    public final GoogleMapOptions mapType(int n) {
        this.mapType = n;
        return this;
    }

    public final GoogleMapOptions camera(CameraPosition cameraPosition) {
        this.zzal = cameraPosition;
        return this;
    }

    public final GoogleMapOptions zoomControlsEnabled(boolean bl) {
        this.zzam = bl;
        return this;
    }

    public final GoogleMapOptions compassEnabled(boolean bl) {
        this.zzan = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabled(boolean bl) {
        this.zzao = bl;
        return this;
    }

    public final GoogleMapOptions zoomGesturesEnabled(boolean bl) {
        this.zzap = bl;
        return this;
    }

    public final GoogleMapOptions tiltGesturesEnabled(boolean bl) {
        this.zzaq = bl;
        return this;
    }

    public final GoogleMapOptions rotateGesturesEnabled(boolean bl) {
        this.zzar = bl;
        return this;
    }

    public final GoogleMapOptions scrollGesturesEnabledDuringRotateOrZoom(boolean bl) {
        this.zzay = bl;
        return this;
    }

    public final GoogleMapOptions liteMode(boolean bl) {
        this.zzas = bl;
        return this;
    }

    public final GoogleMapOptions mapToolbarEnabled(boolean bl) {
        this.zzat = bl;
        return this;
    }

    public final GoogleMapOptions ambientEnabled(boolean bl) {
        this.zzau = bl;
        return this;
    }

    public final GoogleMapOptions minZoomPreference(float f) {
        this.zzav = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions maxZoomPreference(float f) {
        this.zzaw = Float.valueOf(f);
        return this;
    }

    public final GoogleMapOptions latLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.zzax = latLngBounds;
        return this;
    }

    public final Boolean getZOrderOnTop() {
        return this.zzaj;
    }

    public final Boolean getUseViewLifecycleInFragment() {
        return this.zzak;
    }

    public final int getMapType() {
        return this.mapType;
    }

    public final CameraPosition getCamera() {
        return this.zzal;
    }

    public final Boolean getZoomControlsEnabled() {
        return this.zzam;
    }

    public final Boolean getCompassEnabled() {
        return this.zzan;
    }

    public final Boolean getScrollGesturesEnabled() {
        return this.zzao;
    }

    public final Boolean getZoomGesturesEnabled() {
        return this.zzap;
    }

    public final Boolean getTiltGesturesEnabled() {
        return this.zzaq;
    }

    public final Boolean getRotateGesturesEnabled() {
        return this.zzar;
    }

    public final Boolean getScrollGesturesEnabledDuringRotateOrZoom() {
        return this.zzay;
    }

    public final Boolean getLiteMode() {
        return this.zzas;
    }

    public final Boolean getMapToolbarEnabled() {
        return this.zzat;
    }

    public final Boolean getAmbientEnabled() {
        return this.zzau;
    }

    public final Float getMinZoomPreference() {
        return this.zzav;
    }

    public final Float getMaxZoomPreference() {
        return this.zzaw;
    }

    public final LatLngBounds getLatLngBoundsForCameraTarget() {
        return this.zzax;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attributeSet) {
        if (context == null || attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGesturesDuringRotateOrZoom)) {
            googleMapOptions.scrollGesturesEnabledDuringRotateOrZoom(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGesturesDuringRotateOrZoom, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_liteMode)) {
            googleMapOptions.liteMode(typedArray.getBoolean(R.styleable.MapAttrs_liteMode, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiMapToolbar)) {
            googleMapOptions.mapToolbarEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiMapToolbar, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_ambientEnabled)) {
            googleMapOptions.ambientEnabled(typedArray.getBoolean(R.styleable.MapAttrs_ambientEnabled, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMinZoomPreference, Float.NEGATIVE_INFINITY));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraMinZoomPreference)) {
            googleMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.MapAttrs_cameraMaxZoomPreference, Float.POSITIVE_INFINITY));
        }
        LatLngBounds latLngBounds = GoogleMapOptions.zza(context, attributeSet);
        googleMapOptions.latLngBoundsForCameraTarget(latLngBounds);
        CameraPosition cameraPosition = GoogleMapOptions.zzb(context, attributeSet);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }

    public static LatLngBounds zza(Context context, AttributeSet attributeSet) {
        if (context == null || attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        Float f = null;
        Float f2 = null;
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude)) {
            f = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLatitude, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude)) {
            f2 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsSouthWestLongitude, 0.0f));
        }
        Float f3 = null;
        Float f4 = null;
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude)) {
            f3 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLatitude, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude)) {
            f4 = Float.valueOf(typedArray.getFloat(R.styleable.MapAttrs_latLngBoundsNorthEastLongitude, 0.0f));
        }
        typedArray.recycle();
        if (f == null || f2 == null || f3 == null || f4 == null) {
            return null;
        }
        LatLng latLng = new LatLng(f.floatValue(), f2.floatValue());
        LatLng latLng2 = new LatLng(f3.floatValue(), f4.floatValue());
        return new LatLngBounds(latLng, latLng2);
    }

    public static CameraPosition zzb(Context context, AttributeSet attributeSet) {
        if (context == null || attributeSet == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attributeSet, R.styleable.MapAttrs);
        float f = 0.0f;
        float f2 = 0.0f;
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLat)) {
            f = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLat, 0.0f);
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTargetLng)) {
            f2 = typedArray.getFloat(R.styleable.MapAttrs_cameraTargetLng, 0.0f);
        }
        LatLng latLng = new LatLng(f, f2);
        CameraPosition.Builder builder = CameraPosition.builder();
        builder.target(latLng);
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraZoom)) {
            builder.zoom(typedArray.getFloat(R.styleable.MapAttrs_cameraZoom, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraBearing)) {
            builder.bearing(typedArray.getFloat(R.styleable.MapAttrs_cameraBearing, 0.0f));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_cameraTilt)) {
            builder.tilt(typedArray.getFloat(R.styleable.MapAttrs_cameraTilt, 0.0f));
        }
        typedArray.recycle();
        return builder.build();
    }

    public final String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("MapType", (Object)this.mapType).add("LiteMode", (Object)this.zzas).add("Camera", (Object)this.zzal).add("CompassEnabled", (Object)this.zzan).add("ZoomControlsEnabled", (Object)this.zzam).add("ScrollGesturesEnabled", (Object)this.zzao).add("ZoomGesturesEnabled", (Object)this.zzap).add("TiltGesturesEnabled", (Object)this.zzaq).add("RotateGesturesEnabled", (Object)this.zzar).add("ScrollGesturesEnabledDuringRotateOrZoom", (Object)this.zzay).add("MapToolbarEnabled", (Object)this.zzat).add("AmbientEnabled", (Object)this.zzau).add("MinZoomPreference", (Object)this.zzav).add("MaxZoomPreference", (Object)this.zzaw).add("LatLngBoundsForCameraTarget", (Object)this.zzax).add("ZOrderOnTop", (Object)this.zzaj).add("UseViewLifecycleInFragment", (Object)this.zzak).toString();
    }
}

