/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Bitmap;
import android.location.Location;
import android.os.RemoteException;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzah;
import com.google.android.gms.internal.maps.zzau;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.zzal;
import com.google.android.gms.maps.internal.zzd;
import com.google.android.gms.maps.model.AdvancedMarker;
import com.google.android.gms.maps.model.AdvancedMarkerOptions;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.FeatureLayer;
import com.google.android.gms.maps.model.FeatureLayerOptions;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MapCapabilities;
import com.google.android.gms.maps.model.MapColorScheme;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PointOfInterest;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.zza;
import com.google.android.gms.maps.zzaa;
import com.google.android.gms.maps.zzab;
import com.google.android.gms.maps.zzb;
import com.google.android.gms.maps.zzc;
import com.google.android.gms.maps.zze;
import com.google.android.gms.maps.zzf;
import com.google.android.gms.maps.zzg;
import com.google.android.gms.maps.zzh;
import com.google.android.gms.maps.zzi;
import com.google.android.gms.maps.zzj;
import com.google.android.gms.maps.zzk;
import com.google.android.gms.maps.zzm;
import com.google.android.gms.maps.zzn;
import com.google.android.gms.maps.zzo;
import com.google.android.gms.maps.zzp;
import com.google.android.gms.maps.zzq;
import com.google.android.gms.maps.zzr;
import com.google.android.gms.maps.zzs;
import com.google.android.gms.maps.zzt;
import com.google.android.gms.maps.zzu;
import com.google.android.gms.maps.zzv;
import com.google.android.gms.maps.zzw;
import com.google.android.gms.maps.zzx;
import com.google.android.gms.maps.zzy;
import com.google.android.gms.maps.zzz;
import java.util.HashMap;
import java.util.Map;

public class GoogleMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_TERRAIN = 3;
    public static final int MAP_TYPE_HYBRID = 4;
    @NonNull
    public static final String DEMO_MAP_ID = "demo_map_id";
    private final IGoogleMapDelegate zza;
    private MapCapabilities zzb;
    private final Map zzc = new HashMap();
    private final Map zzd = new HashMap();
    private UiSettings zze;

    public final float getMaxZoomLevel() {
        float f;
        try {
            f = this.zza.getMaxZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return f;
    }

    public final float getMinZoomLevel() {
        float f;
        try {
            f = this.zza.getMinZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return f;
    }

    @MapColorScheme
    public int getMapColorScheme() {
        int n;
        try {
            n = this.zza.getMapColorScheme();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    public final int getMapType() {
        int n;
        try {
            n = this.zza.getMapType();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    @Deprecated
    @NonNull
    public final Location getMyLocation() {
        try {
            GoogleMap this_ = this_.zza.getMyLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    @NonNull
    public final Projection getProjection() {
        Projection projection;
        try {
            projection = new Projection(this.zza.getProjection());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return projection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public final UiSettings getUiSettings() {
        try {
            UiSettings uiSettings = ((GoogleMap)this).zze;
            if (uiSettings != null) return ((GoogleMap)this).zze;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        ((GoogleMap)this).zze = new UiSettings(((GoogleMap)this).zza.getUiSettings());
        return ((GoogleMap)this).zze;
    }

    @NonNull
    public final CameraPosition getCameraPosition() {
        try {
            Object this_ = this_.zza.getCameraPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Circle addCircle(@NonNull CircleOptions options) {
        Circle circle;
        try {
            void var1_2;
            Preconditions.checkNotNull((Object)((Object)options), (Object)"CircleOptions must not be null.");
            circle = new Circle(this.zza.addCircle((CircleOptions)var1_2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return circle;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public FeatureLayer getFeatureLayer(@NonNull FeatureLayerOptions featureLayerOptions) {
        void var1_2;
        String string = featureLayerOptions.getFeatureType();
        String string2 = var1_2.getDatasetId();
        boolean bl = string.equals("DATASET");
        FeatureLayer featureLayer = bl ? (FeatureLayer)this.zzd.get(string2) : (FeatureLayer)this.zzd.get(string);
        if (featureLayer != null) return featureLayer;
        try {
            featureLayer = new FeatureLayer(this.zza.getFeatureLayer((FeatureLayerOptions)var1_2));
            if (bl) {
                this.zzd.put(string2, featureLayer);
                return featureLayer;
            }
            this.zzd.put(string, featureLayer);
            return featureLayer;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Nullable
    public final GroundOverlay addGroundOverlay(@NonNull GroundOverlayOptions options) {
        block3: {
            GroundOverlay groundOverlay;
            try {
                Preconditions.checkNotNull((Object)((Object)options), (Object)"GroundOverlayOptions must not be null.");
                com.google.android.gms.internal.maps.zzv zzv2 = ((GoogleMap)((Object)zzv2)).zza.addGroundOverlay((GroundOverlayOptions)((Object)groundOverlay));
                if (zzv2 == null) break block3;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            groundOverlay = new GroundOverlay(zzv2);
            return groundOverlay;
        }
        return null;
    }

    @Nullable
    public IndoorBuilding getFocusedBuilding() {
        block3: {
            try {
                com.google.android.gms.internal.maps.zzy this_ = ((GoogleMap)((Object)this_)).zza.getFocusedBuilding();
                if (this_ == null) break block3;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            IndoorBuilding indoorBuilding = new IndoorBuilding(this_);
            return indoorBuilding;
        }
        return null;
    }

    @NonNull
    public MapCapabilities getMapCapabilities() {
        if (this.zzb == null) {
            try {
                this.zzb = new MapCapabilities(this.zza.getMapCapabilities());
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Marker addMarker(@NonNull MarkerOptions options) {
        block6: {
            void var1_2;
            if (options instanceof AdvancedMarkerOptions) {
                var1_2.zzf(1);
            }
            try {
                Preconditions.checkNotNull((Object)var1_2, (Object)"MarkerOptions must not be null.");
                zzah zzah2 = ((GoogleMap)((Object)zzah2)).zza.addMarker((MarkerOptions)var1_2);
                if (zzah2 == null) return null;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            int n = var1_2.zzb();
            if (n != 1) break block6;
            return new AdvancedMarker(zzah2);
        }
        return new Marker(zzah2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Polygon addPolygon(@NonNull PolygonOptions options) {
        Polygon polygon;
        try {
            void var1_2;
            Preconditions.checkNotNull((Object)((Object)options), (Object)"PolygonOptions must not be null");
            polygon = new Polygon(this.zza.addPolygon((PolygonOptions)var1_2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return polygon;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Polyline addPolyline(@NonNull PolylineOptions options) {
        Polyline polyline;
        try {
            void var1_2;
            Preconditions.checkNotNull((Object)((Object)options), (Object)"PolylineOptions must not be null");
            polyline = new Polyline(this.zza.addPolyline((PolylineOptions)var1_2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return polyline;
    }

    @Nullable
    public final TileOverlay addTileOverlay(@NonNull TileOverlayOptions options) {
        block3: {
            TileOverlay tileOverlay;
            try {
                Preconditions.checkNotNull((Object)((Object)options), (Object)"TileOverlayOptions must not be null.");
                zzau zzau2 = ((GoogleMap)((Object)zzau2)).zza.addTileOverlay((TileOverlayOptions)((Object)tileOverlay));
                if (zzau2 == null) break block3;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            tileOverlay = new TileOverlay(zzau2);
            return tileOverlay;
        }
        return null;
    }

    public GoogleMap(@NonNull IGoogleMapDelegate iGoogleMapDelegate) {
        this.zza = (IGoogleMapDelegate)Preconditions.checkNotNull((Object)iGoogleMapDelegate);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addOnMapCapabilitiesChangedListener(@NonNull OnMapCapabilitiesChangedListener listener) {
        try {
            void var1_2;
            zzs zzs2 = new zzs(this, (OnMapCapabilitiesChangedListener)var1_2);
            this.zzc.put(var1_2, zzs2);
            this.zza.addOnMapCapabilitiesChangedListener(zzs2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void animateCamera(@NonNull CameraUpdate update) {
        try {
            void var1_2;
            Preconditions.checkNotNull((Object)var1_2, (Object)"CameraUpdate must not be null.");
            this.zza.animateCamera(var1_2.zza());
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void animateCamera(@NonNull CameraUpdate update, @Nullable CancelableCallback callback) {
        try {
            void var2_3;
            IObjectWrapper iObjectWrapper;
            Preconditions.checkNotNull((Object)update, (Object)"CameraUpdate must not be null.");
            IGoogleMapDelegate iGoogleMapDelegate = ((GoogleMap)object).zza;
            iObjectWrapper = iObjectWrapper.zza();
            Object object = var2_3 == null ? null : new zzab((CancelableCallback)var2_3);
            iGoogleMapDelegate.animateCameraWithCallback(iObjectWrapper, (zzd)object);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void animateCamera(@NonNull CameraUpdate update, int durationMs, @Nullable CancelableCallback callback) {
        try {
            void var2_3;
            void var3_4;
            IObjectWrapper iObjectWrapper;
            Preconditions.checkNotNull((Object)update, (Object)"CameraUpdate must not be null.");
            IGoogleMapDelegate iGoogleMapDelegate = ((GoogleMap)object).zza;
            iObjectWrapper = iObjectWrapper.zza();
            Object object = var3_4 == null ? null : new zzab((CancelableCallback)var3_4);
            iGoogleMapDelegate.animateCameraWithDurationAndCallback(iObjectWrapper, (int)var2_3, (zzd)object);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void clear() {
        try {
            this.zza.clear();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void moveCamera(@NonNull CameraUpdate update) {
        try {
            void var1_2;
            Preconditions.checkNotNull((Object)var1_2, (Object)"CameraUpdate must not be null.");
            this.zza.moveCamera(var1_2.zza());
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeOnMapCapabilitiesChangedListener(@NonNull OnMapCapabilitiesChangedListener listener) {
        block3: {
            void var1_2;
            try {
                boolean bl = this.zzc.containsKey(var1_2);
                if (!bl) break block3;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            this.zza.removeOnMapCapabilitiesChangedListener((zzal)this.zzc.get(var1_2));
            this.zzc.remove(var1_2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetMinMaxZoomPreference() {
        try {
            this.zza.resetMinMaxZoomPreference();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setBuildingsEnabled(boolean enabled) {
        try {
            void var1_2;
            this.zza.setBuildingsEnabled((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setContentDescription(@Nullable String description) {
        try {
            void var1_2;
            this.zza.setContentDescription((String)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setInfoWindowAdapter(@Nullable InfoWindowAdapter adapter) {
        if (adapter != null) ** GOTO lbl5
        try {
            this.zza.setInfoWindowAdapter(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setInfoWindowAdapter(new zzf(this, (InfoWindowAdapter)var1_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLatLngBoundsForCameraTarget(@Nullable LatLngBounds bounds) {
        try {
            void var1_2;
            this.zza.setLatLngBoundsForCameraTarget((LatLngBounds)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setLocationSource(@Nullable LocationSource source) {
        if (source != null) ** GOTO lbl5
        try {
            this.zza.setLocationSource(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setLocationSource(new zzt(this, (LocationSource)var1_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMapColorScheme(@MapColorScheme int mapColorScheme) {
        try {
            void var1_2;
            this.zza.setMapColorScheme((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setMapType(int type) {
        try {
            void var1_2;
            this.zza.setMapType((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxZoomPreference(float maxZoomPreference) {
        try {
            void var1_2;
            this.zza.setMaxZoomPreference((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMinZoomPreference(float minZoomPreference) {
        try {
            void var1_2;
            this.zza.setMinZoomPreference((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final void setMyLocationEnabled(boolean enabled) {
        try {
            void var1_2;
            this.zza.setMyLocationEnabled((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public final void setOnCameraChangeListener(@Nullable OnCameraChangeListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraChangeListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnCameraChangeListener(new zzu(this, (OnCameraChangeListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCameraIdleListener(@Nullable OnCameraIdleListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraIdleListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnCameraIdleListener(new zzy(this, (OnCameraIdleListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCameraMoveCanceledListener(@Nullable OnCameraMoveCanceledListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraMoveCanceledListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnCameraMoveCanceledListener(new zzx(this, (OnCameraMoveCanceledListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCameraMoveListener(@Nullable OnCameraMoveListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraMoveListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnCameraMoveListener(new zzw(this, (OnCameraMoveListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCameraMoveStartedListener(@Nullable OnCameraMoveStartedListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCameraMoveStartedListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnCameraMoveStartedListener(new zzv(this, (OnCameraMoveStartedListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnCircleClickListener(@Nullable OnCircleClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnCircleClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnCircleClickListener(new zzn(this, (OnCircleClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnGroundOverlayClickListener(@Nullable OnGroundOverlayClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnGroundOverlayClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnGroundOverlayClickListener(new zzm(this, (OnGroundOverlayClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnIndoorStateChangeListener(@Nullable OnIndoorStateChangeListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnIndoorStateChangeListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnIndoorStateChangeListener(new zzk(this, (OnIndoorStateChangeListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnInfoWindowClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnInfoWindowClickListener(new zzc(this, (OnInfoWindowClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnInfoWindowCloseListener(@Nullable OnInfoWindowCloseListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnInfoWindowCloseListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnInfoWindowCloseListener(new zze(this, (OnInfoWindowCloseListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnInfoWindowLongClickListener(@Nullable OnInfoWindowLongClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnInfoWindowLongClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnInfoWindowLongClickListener(new com.google.android.gms.maps.zzd(this, (OnInfoWindowLongClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMapClickListener(@Nullable OnMapClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMapClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnMapClickListener(new zzz(this, (OnMapClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnMapLoadedCallback(@Nullable OnMapLoadedCallback callback) {
        if (callback != null) ** GOTO lbl5
        try {
            this.zza.setOnMapLoadedCallback(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnMapLoadedCallback(new zzj(this, (OnMapLoadedCallback)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMapLongClickListener(@Nullable OnMapLongClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMapLongClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnMapLongClickListener(new zzaa(this, (OnMapLongClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMarkerClickListener(@Nullable OnMarkerClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMarkerClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnMarkerClickListener(new zza(this, (OnMarkerClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMarkerDragListener(@Nullable OnMarkerDragListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMarkerDragListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnMarkerDragListener(new zzb(this, (OnMarkerDragListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMyLocationButtonClickListener(@Nullable OnMyLocationButtonClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMyLocationButtonClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnMyLocationButtonClickListener(new zzh(this, (OnMyLocationButtonClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public final void setOnMyLocationChangeListener(@Nullable OnMyLocationChangeListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMyLocationChangeListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnMyLocationChangeListener(new zzg(this, (OnMyLocationChangeListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnMyLocationClickListener(@Nullable OnMyLocationClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnMyLocationClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnMyLocationClickListener(new zzi(this, (OnMyLocationClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnPoiClickListener(@Nullable OnPoiClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnPoiClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnPoiClickListener(new zzr(this, (OnPoiClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnPolygonClickListener(@Nullable OnPolygonClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnPolygonClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnPolygonClickListener(new zzo(this, (OnPolygonClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setOnPolylineClickListener(@Nullable OnPolylineClickListener listener) {
        if (listener != null) ** GOTO lbl5
        try {
            this.zza.setOnPolylineClickListener(null);
            return;
lbl5:
            // 1 sources

            var2_3 = this.zza;
        }
        catch (RemoteException var0_1) {
            throw new RuntimeRemoteException(var0_1);
        }
        {
            var2_3.setOnPolylineClickListener(new zzp(this, (OnPolylineClickListener)var1_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setPadding(int left, int top, int right, int bottom) {
        try {
            void var4_5;
            void var3_4;
            void var2_3;
            void var1_2;
            this.zza.setPadding((int)var1_2, (int)var2_3, (int)var3_4, (int)var4_5);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setTrafficEnabled(boolean enabled) {
        try {
            void var1_2;
            this.zza.setTrafficEnabled((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void snapshot(@NonNull SnapshotReadyCallback callback) {
        void var1_1;
        Preconditions.checkNotNull((Object)callback, (Object)"Callback must not be null.");
        this.snapshot((SnapshotReadyCallback)var1_1, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void snapshot(@NonNull SnapshotReadyCallback callback, @Nullable Bitmap bitmap) {
        IObjectWrapper iObjectWrapper;
        Preconditions.checkNotNull((Object)callback, (Object)"Callback must not be null.");
        iObjectWrapper = iObjectWrapper != null ? ObjectWrapper.wrap((Object)iObjectWrapper) : null;
        iObjectWrapper = (ObjectWrapper)iObjectWrapper;
        try {
            void var1_2;
            IGoogleMapDelegate iGoogleMapDelegate = this.zza;
            iGoogleMapDelegate.snapshot(new zzq(this, (SnapshotReadyCallback)var1_2), iObjectWrapper);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void stopAnimation() {
        try {
            this.zza.stopAnimation();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isBuildingsEnabled() {
        boolean bl;
        try {
            bl = this.zza.isBuildingsEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public final boolean isIndoorEnabled() {
        boolean bl;
        try {
            bl = this.zza.isIndoorEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public final boolean isMyLocationEnabled() {
        boolean bl;
        try {
            bl = this.zza.isMyLocationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public final boolean isTrafficEnabled() {
        boolean bl;
        try {
            bl = this.zza.isTrafficEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setIndoorEnabled(boolean enabled) {
        boolean bl;
        try {
            void var1_3;
            bl = this.zza.setIndoorEnabled((boolean)var1_3);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setMapStyle(@Nullable MapStyleOptions style) {
        boolean bl;
        try {
            void var1_3;
            bl = this.zza.setMapStyle((MapStyleOptions)var1_3);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public static interface CancelableCallback {
        public void onCancel();

        public void onFinish();
    }

    public static interface OnIndoorStateChangeListener {
        public void onIndoorBuildingFocused();

        public void onIndoorLevelActivated(@NonNull IndoorBuilding var1);
    }

    @Deprecated
    public static interface OnCameraChangeListener {
        public void onCameraChange(@NonNull CameraPosition var1);
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_GESTURE = 1;
        public static final int REASON_API_ANIMATION = 2;
        public static final int REASON_DEVELOPER_ANIMATION = 3;

        public void onCameraMoveStarted(int var1);
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnMapClickListener {
        public void onMapClick(@NonNull LatLng var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(@NonNull LatLng var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(@NonNull Marker var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(@NonNull Marker var1);

        public void onMarkerDragEnd(@NonNull Marker var1);

        public void onMarkerDragStart(@NonNull Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(@NonNull Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(@NonNull Marker var1);
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(@NonNull Marker var1);
    }

    public static interface InfoWindowAdapter {
        @Nullable
        public View getInfoContents(@NonNull Marker var1);

        @Nullable
        public View getInfoWindow(@NonNull Marker var1);
    }

    @Deprecated
    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(@NonNull Location var1);
    }

    public static interface OnMyLocationButtonClickListener {
        public boolean onMyLocationButtonClick();
    }

    public static interface OnMyLocationClickListener {
        public void onMyLocationClick(@NonNull Location var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnGroundOverlayClickListener {
        public void onGroundOverlayClick(@NonNull GroundOverlay var1);
    }

    public static interface OnCircleClickListener {
        public void onCircleClick(@NonNull Circle var1);
    }

    public static interface OnPolygonClickListener {
        public void onPolygonClick(@NonNull Polygon var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(@NonNull Polyline var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(@Nullable Bitmap var1);
    }

    public static interface OnPoiClickListener {
        public void onPoiClick(@NonNull PointOfInterest var1);
    }

    public static interface OnMapCapabilitiesChangedListener {
        public void onMapCapabilitiesChanged(@NonNull MapCapabilities var1);
    }
}

